/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


public class PivotValueProviderEvent extends java.util.EventObject {

	/**
	 *  CALCULATION_START_REQUESTED will be fired before calculation caused by operation like fields update, etc.
	 */
	public static final int CALCULATION_START_REQUESTED = 0;

	/**
	 *  CALCULATION_START_REQUESTED will be fired before calculation caused by original data update.
	 */
	public static final int CALCULATION_START_DATA_UPDATED = 1;

	/**
	 *  CALCULATION_END_WITH_STRUCTURE_CHANGED will be fired after calculation with structure changed.
	 *  <p/>
	 *  Pair with CALCULATION_START_REQUESTED or CALCULATION_START_DATA_UPDATED.
	 *  <p/>
	 *  It will contains the CALCULATION_START_DATA_UPDATED in its object if it's triggered by original data update. PivotTablePane
	 *  would not rearrange the pivot field with this field filled.
	 */
	public static final int CALCULATION_END_WITH_STRUCTURE_CHANGED = 2;

	/**
	 *  CALCULATION_END_ONLY_RESULT_UPDATED will be fired after calculation with only result updated. The hierarchy does
	 *  not change.
	 *  <p/>
	 *  Pair with CALCULATION_START_REQUESTED or CALCULATION_START_DATA_UPDATED.
	 */
	public static final int CALCULATION_END_ONLY_RESULT_UPDATED = 3;

	/**
	 *  ADJUSTING_START will be fired before sorting or other non-calculation scenario.
	 *  <p/>
	 *  PivotTablePane would use this event to save selections or support other persistence mechanism.
	 */
	public static final int ADJUSTING_START = 4;

	/**
	 *  ADJUSTING_END_ROW_HEADER_CHANGE will be fired after adjusting end and row header table update is required.
	 *  <p/>
	 *  Pair with ADJUSTING_START
	 */
	public static final int ADJUSTING_END_ROW_HEADER_CHANGE = 5;

	/**
	 *  ADJUSTING_END_COLUMN_HEADER_CHANGE will be fired after adjusting end and column header table update is required.
	 *  <p/>
	 *  Pair with ADJUSTING_START
	 */
	public static final int ADJUSTING_END_COLUMN_HEADER_CHANGE = 6;

	/**
	 *  ADJUSTING_END_BOTH_HEADERS_CHANGE will be fired after adjusting end and both header tables update are required.
	 *  <p/>
	 *  Pair with ADJUSTING_START
	 */
	public static final int ADJUSTING_END_BOTH_HEADERS_CHANGE = 7;

	/**
	 *  ADJUSTING_END_UPDATE_DATA_TABLE_ONLY will be fired after adjusting end and no header tables update is required.
	 *  <p/>
	 *  Pair with ADJUSTING_START
	 */
	public static final int ADJUSTING_END_UPDATE_DATA_TABLE_ONLY = 8;

	/**
	 *  INFO_AFFECTED_VALUES will be fired after CALCULATION_END_WITH_STRUCTURE_CHANGED or CALCULATION_END_ONLY_RESULT_UPDATED
	 *  if {@link CalculatedPivotDataModel#isComputeAffectedCellOnUpdate()} returns true.
	 *  <p/>
	 *  If you get this event from CalculatedPivotDataModel, it would contain an array to indicate impacted cells in the PivotTablePane.
	 *  Every 5 items represents one cell. In order, they are rowValues, columnValues, PivotField(the data field), old value and new value.
	 *  <p/>
	 *  If you get this event from PivotDataModel, the array would not be able to contain the value information since it does not have cache.
	 *  Every 3 items represents one cell. In order, they are rowValues, columnValues and PivotField(the data field).
	 *  <p/>
	 *  NOTE: oldValue equals null means that, either the value is null or the values was not cached.
	 */
	public static final int INFO_AFFECTED_VALUES = 9;

	public PivotValueProviderEvent(Object source, int type) {
	}

	public PivotValueProviderEvent(Object source, int type, Object object) {
	}

	/**
	 *  Get the event type.
	 * 
	 *  @return the event type.
	 */
	public int getType() {
	}

	/**
	 *  Get the event related object. In collapse/expand scenario, while the event type is ADJUSTING_END_BOTH_HEADERS_CHANGE,
	 *  the object is an array of Expandable which just changed collapse/expand status. In other scenarios, it's always null. 
	 * 
	 *  @return the event related object.
	 */
	public Object getObject() {
	}
}
