/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A sortable AggregateTableModel used by AggregateTable. If the AggregateTable is sortable, it will use this model by
 *  default.
 */
public class SortableAggregateTableModel extends SortableTableModel {

	public SortableAggregateTableModel(javax.swing.table.TableModel model) {
	}

	/**
	 *  Sorts the aggregate table model. Subclass can override to provide an optimized way to sort the table. You can get
	 *  the grouping column information by using getMasterSortColumns() and get all sorting column information by using
	 *  getSortingColumns().
	 */
	@java.lang.Override
	protected void sort() {
	}

	/**
	 *  Compares the two cell values at the two rows. Since we have to keep summary value on the bottom, so the return
	 *  value has a little bit confusion here. if one of the two rows is a summary value and the column is not a grouping
	 *  column, we use Integer.MIN_VALUE or Integer.MAX_VALUE so the value will not be changed by sorting direction. With
	 *  this algorithm, we don't have to override {@link #compare(int,int)}. if two rows are both summary values with
	 *  same prefix values, we now just keep the original order. You can choose to override this method if you want to
	 *  sort summary values as well.
	 * 
	 *  @param row1   index of the first row to be compared
	 *  @param row2   index of the second row to be compared
	 *  @param column the column index of both rows.
	 *  @return If it returns > 0, it means the first value is greater than the second value. If it returns -1, it means
	 *          the second value is greater than the first value. If it returns 0, it means the two values are the same.
	 *          If it returns Integer.MAX_VALUE, the first value is always appear after the second value, regarding of
	 *          the order is ascending or descending. If it returns Integer.MIN_VALUE, the first value is always appear
	 *          before the second value, regarding of the order is ascending or descending.
	 */
	@java.lang.Override
	public int compare(int row1, int row2, int column) {
	}
}
