/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  A summary interface to calculate a custom summary. This class is used by {@link
 *  PivotField#setCustomSummary(Summary)}. When {@link PivotField#getSummaryType()} equals SUMMARY_CUSTOM, the Summary in
 *  setCustomSummary will be used to compute the summary.
 */
public interface Summary {

	/**
	 *  The name of the summary.
	 * 
	 *  @return the name of the summary.
	 */
	public String getName();

	/**
	 *  Gets the summary result. It will use the array of input data and calculated the summary. For example, if you want
	 *  to do a SUM summary, simply add all values up and return the total.
	 * 
	 *  @param values the input value. It's an array of data.
	 *  @return the summary.
	 */
	public Object getResult(Object[] values);
}
