/**
 *  The package contains classes for JIDE Pivot Grid product.
 */
package com.jidesoft.pivot;


/**
 *  An interface to represent any value in pivot data model. It is used in HeaderTableModel as part of the data structure
 *  to store the data. The Value wraps the actual value and also has additional information depending on its usage, such
 *  as SummaryValue has the summary type, DefaultExpandableValue can has its own children.
 */
public interface Value {

	/**
	 *  Gets the value.
	 * 
	 *  @return the value.
	 */
	public Object getValue();

	/**
	 *  Sets the value.
	 * 
	 *  @param value the actual value for this Value object.
	 */
	public void setValue(Object value);
}
