/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.world;

import java.util.Random;
import mrtjp.core.handler.MrTJPConfig$;
import mrtjp.core.handler.MrTJPCoreMod$;
import mrtjp.core.world.ISimpleStructureGen;
import mrtjp.core.world.SimpleGenHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

public final class SimpleGenHandler$
implements IWorldGenerator {
    public static final SimpleGenHandler$ MODULE$;
    private Seq<ISimpleStructureGen> structures;
    private long structHash;
    private Map<Object, Queue<SimpleGenHandler.ChunkCoord>> genQueue;
    private final boolean retroGen;
    private final String tagDB;

    static {
        new SimpleGenHandler$();
    }

    private Seq<ISimpleStructureGen> structures() {
        return this.structures;
    }

    private void structures_$eq(Seq<ISimpleStructureGen> x$1) {
        this.structures = x$1;
    }

    private long structHash() {
        return this.structHash;
    }

    private void structHash_$eq(long x$1) {
        this.structHash = x$1;
    }

    private Map<Object, Queue<SimpleGenHandler.ChunkCoord>> genQueue() {
        return this.genQueue;
    }

    private void genQueue_$eq(Map<Object, Queue<SimpleGenHandler.ChunkCoord>> x$1) {
        this.genQueue = x$1;
    }

    private boolean retroGen() {
        return this.retroGen;
    }

    private String tagDB() {
        return this.tagDB;
    }

    public void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
        if (this.retroGen()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void registerStructure(ISimpleStructureGen struct) {
        if (this.structures().exists((Function1)new Serializable(struct){
            private final ISimpleStructureGen struct$1;

            public final boolean apply(ISimpleStructureGen x$1) {
                String string = x$1.genID();
                String string2 = this.struct$1.genID();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.struct$1 = struct$1;
            }
        })) {
            MrTJPCoreMod$.MODULE$.log().error("MrTJP Structure gen duplicate structure '%s'", new Object[]{struct.genID()});
        } else {
            this.structures_$eq((Seq<ISimpleStructureGen>)((Seq)this.structures().$colon$plus((Object)struct, Seq$.MODULE$.canBuildFrom())));
            this.structHash_$eq(this.structHash() + (long)struct.genID().hashCode());
        }
    }

    @SubscribeEvent
    public void chunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound genNBT = event.getData().getCompoundTag(this.tagDB());
        NBTTagList structList = new NBTTagList();
        this.structures().foreach((Function1)new Serializable(structList){
            private final NBTTagList structList$1;

            public final void apply(ISimpleStructureGen g) {
                this.structList$1.appendTag((NBTBase)new NBTTagString(g.genID()));
            }
            {
                this.structList$1 = structList$1;
            }
        });
        genNBT.setTag("StructList", (NBTBase)structList);
        genNBT.setLong("StructHash", this.structHash());
        event.getData().setTag(this.tagDB(), (NBTBase)genNBT);
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkDataEvent.Load event) {
        if (this.retroGen()) {
            NBTTagList list;
            int dim = event.getWorld().provider.getDimension();
            NBTTagCompound tag = (NBTTagCompound)event.getData().getTag(this.tagDB());
            NBTTagList nBTTagList = list = tag == null ? new NBTTagList() : tag.getTagList("StructList", 8);
            if (tag == null || tag.getLong("StructHash") != this.structHash() || list.tagCount() != this.structures().size()) {
                SimpleGenHandler.ChunkCoord chunk = new SimpleGenHandler.ChunkCoord(event.getChunk().xPosition, event.getChunk().zPosition, list);
                Queue chunks = (Queue)this.genQueue().getOrElse((Object)BoxesRunTime.boxToInteger((int)dim), (Function0)new Serializable(){

                    public final Queue<SimpleGenHandler.ChunkCoord> apply() {
                        return (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                });
                chunks.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleGenHandler.ChunkCoord[]{chunk}));
                this.genQueue_$eq((Map<Object, Queue<SimpleGenHandler.ChunkCoord>>)this.genQueue().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dim)), (Object)chunks)));
            }
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator g, IChunkProvider p) {
        this.subGenerate(world, chunkX, chunkZ, rand, false, this.subGenerate$default$6());
    }

    private void subGenerate(World w, int chunkX, int chunkZ, Random rand, boolean isRetro, Set<String> existingStructs) {
        BooleanRef gen = BooleanRef.create((boolean)false);
        this.structures().foreach((Function1)new Serializable(w, chunkX, chunkZ, rand, isRetro, existingStructs, gen){
            private final World w$1;
            private final int chunkX$1;
            private final int chunkZ$1;
            private final Random rand$1;
            private final boolean isRetro$1;
            private final Set existingStructs$1;
            private final BooleanRef gen$1;

            public final void apply(ISimpleStructureGen s) {
                if (!this.existingStructs$1.contains((Object)s.genID())) {
                    this.gen$1.elem |= s.generate(this.w$1, this.chunkX$1, this.chunkZ$1, this.rand$1, this.isRetro$1);
                }
            }
            {
                this.w$1 = w$1;
                this.chunkX$1 = chunkX$1;
                this.chunkZ$1 = chunkZ$1;
                this.rand$1 = rand$1;
                this.isRetro$1 = isRetro$1;
                this.existingStructs$1 = existingStructs$1;
                this.gen$1 = gen$1;
            }
        });
        if (isRetro && gen.elem) {
            w.getChunkFromChunkCoords(chunkX, chunkZ).setChunkModified();
        }
    }

    private Set<String> subGenerate$default$6() {
        return Predef$.MODULE$.Set().empty();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.WorldTickEvent event) {
        Side side = event.side;
        Side side2 = Side.SERVER;
        if (!(side != null ? !side.equals(side2) : side2 != null)) {
            TickEvent.Phase phase = event.phase;
            TickEvent.Phase phase2 = TickEvent.Phase.END;
            if (!(phase != null ? !phase.equals(phase2) : phase2 != null)) {
                World world = event.world;
                int dim = world.provider.getDimension();
                if (world.getWorldTime() % 10L != 0L) {
                    return;
                }
                if (this.genQueue().contains((Object)BoxesRunTime.boxToInteger((int)dim))) {
                    Queue chunks = (Queue)this.genQueue().apply((Object)BoxesRunTime.boxToInteger((int)dim));
                    if (chunks.nonEmpty()) {
                        SimpleGenHandler.ChunkCoord chunk = (SimpleGenHandler.ChunkCoord)chunks.dequeue();
                        long worldSeed = world.getSeed();
                        Random rand = new Random(worldSeed);
                        long xSeed = rand.nextLong() >> (int)3L;
                        long zSeed = rand.nextLong() >> (int)3L;
                        rand.setSeed(xSeed * (long)chunk.chunkX() + zSeed * (long)chunk.chunkZ() ^ worldSeed);
                        MrTJPCoreMod$.MODULE$.log().warn(new StringBuilder().append((Object)"Starting Retrogeneration on chunk @[DIM ").append((Object)BoxesRunTime.boxToInteger((int)dim)).append((Object)"]").append((Object)chunk.toString()).toString());
                        this.subGenerate(world, chunk.chunkX(), chunk.chunkZ(), rand, true, chunk.structList());
                    }
                    if (chunks.isEmpty()) {
                        this.genQueue_$eq((Map<Object, Queue<SimpleGenHandler.ChunkCoord>>)((Map)this.genQueue().$minus((Object)BoxesRunTime.boxToInteger((int)dim))));
                    }
                    return;
                }
                return;
            }
        }
    }

    private SimpleGenHandler$() {
        MODULE$ = this;
        this.structures = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.structHash = 0L;
        this.genQueue = ((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).withDefaultValue((Object)Queue$.MODULE$.apply((Seq)Nil$.MODULE$));
        this.retroGen = MrTJPConfig$.MODULE$.retro_gen();
        this.tagDB = new StringBuilder().append((Object)"RetrogenData_").append((Object)MrTJPConfig$.MODULE$.retro_gen_id()).toString();
    }
}

