/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.world;

import mrtjp.core.math.PerlinNoiseGenerator;
import mrtjp.core.world.WorldLib$;
import mrtjp.core.world.WorldLib$$anonfun$bulkBlockUpdate$1$;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class WorldLib$ {
    public static final WorldLib$ MODULE$;
    private final PerlinNoiseGenerator noise;

    static {
        new WorldLib$();
    }

    public void bulkBlockUpdate(World world, BlockPos pos, Block bl) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(world, pos){
            public final World world$2;
            public final BlockPos pos$2;

            public final void apply(int a) {
                this.apply$mcVI$sp(a);
            }

            public void apply$mcVI$sp(int a) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(this, a){
                    private final /* synthetic */ anonfun.bulkBlockUpdate.1 $outer;
                    public final int a$1;

                    public final void apply(int b) {
                        this.apply$mcVI$sp(b);
                    }

                    public void apply$mcVI$sp(int b) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(this, b){
                            private final /* synthetic */ anonfun$bulkBlockUpdate$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final int b$1;

                            public final void apply(int c) {
                                this.apply$mcVI$sp(c);
                            }

                            public void apply$mcVI$sp(int c) {
                                int md = (this.$outer.a$1 < 0 ? -this.$outer.a$1 : this.$outer.a$1) + (this.b$1 < 0 ? -this.b$1 : this.b$1) + (c < 0 ? -c : c);
                                if (md <= 3) {
                                    BlockPos pos2 = new BlockPos(this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().pos$2.getX() + this.$outer.a$1, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().pos$2.getY() + this.b$1, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().pos$2.getZ() + c);
                                    IBlockState state = this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().world$2.getBlockState(pos2);
                                    state.getBlock().onNeighborChange((IBlockAccess)this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().world$2, pos2, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().pos$2);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.b$1 = b$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.bulkBlockUpdate.1 mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                    }
                });
            }
            {
                this.world$2 = world$2;
                this.pos$2 = pos$2;
            }
        });
    }

    public void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (!world.isRemote && world.getGameRules().getBoolean("doTileDrops")) {
            double d = 0.7;
            double dx = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
            double dy = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
            double dz = (double)world.rand.nextFloat() * d + (1.0 - d) * 0.5;
            EntityItem item = new EntityItem(world, (double)pos.getX() + dx, (double)pos.getY() + dy, (double)pos.getZ() + dz, stack);
            item.setPickupDelay(10);
            world.spawnEntityInWorld((Entity)item);
        }
    }

    public void centerEject(World w, BlockPos pos, ItemStack stack, int dir, double vel) {
        BlockPos pos2 = pos.offset(EnumFacing.values()[dir]);
        EntityItem item = new EntityItem(w, (double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5, stack);
        item.motionX = 0.0;
        item.motionY = 0.0;
        item.motionZ = 0.0;
        item.setPickupDelay(10);
        int n = dir;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 5: {
                item.motionX = vel;
                break;
            }
            case 4: {
                item.motionX = -vel;
                break;
            }
            case 3: {
                item.motionZ = vel;
                break;
            }
            case 2: {
                item.motionZ = -vel;
                break;
            }
            case 1: {
                item.motionY = vel;
                break;
            }
            case 0: {
                item.motionY = -vel;
            }
        }
        w.spawnEntityInWorld((Entity)item);
    }

    public void uncheckedSetBlock(World world, BlockPos pos, IBlockState state) {
        Chunk ch = world.getChunkFromBlockCoords(pos);
        ExtendedBlockStorage[] arr = ch.getBlockStorageArray();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (arr[y >> 4] == null) {
            arr[y >> 4] = new ExtendedBlockStorage(y & ~15, !world.provider.getHasNoSky());
        }
        IBlockState oldState = arr[y >> 4].get(x, y, z);
        arr[y >> 4].set(x, y, z, state);
        world.markBlockRangeForRenderUpdate(pos, pos);
        world.notifyBlockUpdate(pos, oldState, state, 3);
    }

    public void uncheckedRemoveTileEntity(World world, BlockPos pos) {
        Chunk ch = world.getChunkFromBlockCoords(pos);
        ch.getTileEntityMap().remove(pos);
    }

    public void uncheckedSetTileEntity(World world, BlockPos pos, TileEntity tile) {
        Chunk ch = world.getChunkFromBlockCoords(pos);
        ch.getTileEntityMap().put(pos, tile);
    }

    public TileEntity uncheckedGetTileEntity(World world, BlockPos pos) {
        Chunk ch = world.getChunkFromBlockCoords(pos);
        return (TileEntity)ch.getTileEntityMap().get(pos);
    }

    public boolean hasItem(IBlockState state) {
        return Item.getItemFromBlock((Block)state.getBlock()) != null;
    }

    public boolean isLeafType(World world, BlockPos pos, IBlockState state) {
        return state.getBlock().isLeaves(state, (IBlockAccess)world, pos) || this.hasItem(state) && Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)new ItemStack(state.getBlock()))).contains((Object)BoxesRunTime.boxToInteger((int)OreDictionary.getOreID((String)"treeLeaves")));
    }

    public boolean isWoodType(World world, BlockPos pos, IBlockState state) {
        return state.getBlock().isWood((IBlockAccess)world, pos) || this.hasItem(state) && Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)new ItemStack(state.getBlock()))).contains((Object)BoxesRunTime.boxToInteger((int)OreDictionary.getOreID((String)"logWood")));
    }

    public boolean isPlantType(World world, BlockPos pos, IBlockState state) {
        Block block;
        Block block2 = state.getBlock();
        boolean bl = block2 instanceof IGrowable ? !((block = block2) instanceof BlockGrass) : (block2 instanceof IPlantable ? true : state.getBlock().isFoliage((IBlockAccess)world, pos));
        return bl;
    }

    public boolean isBlockSoft(World world, BlockPos pos, IBlockState state) {
        return state.getBlock().isAir(state, (IBlockAccess)world, pos) || state.getBlock().isReplaceable((IBlockAccess)world, pos) || this.isLeafType(world, pos, state) || this.isPlantType(world, pos, state) || state.getBlock().canBeReplacedByLeaves(state, (IBlockAccess)world, pos);
    }

    public boolean isAssociatedTreeBlock(World world, BlockPos pos, IBlockState state) {
        return ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Block[]{Blocks.LOG, Blocks.LOG2, Blocks.LEAVES, Blocks.LEAVES2, Blocks.VINE, Blocks.COCOA}))).contains((Object)state.getBlock()) || this.isLeafType(world, pos, state) || this.isWoodType(world, pos, state);
    }

    /*
     * WARNING - void declaration
     */
    public BlockPos findSurfaceHeight(World world, BlockPos pos) {
        void var3_3;
        IBlockState b;
        BlockPos pos2 = world.getHeight(pos).up();
        while ((pos2 = pos2.down()).getY() >= 0 && (this.isBlockSoft(world, pos2, b = world.getBlockState(pos2)) || this.isAssociatedTreeBlock(world, pos2, b))) {
        }
        return var3_3;
    }

    public boolean isBlockTouchingAir(World world, BlockPos pos) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(world, pos, object){
                    private final World world$1;
                    private final BlockPos pos$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int s) {
                        this.apply$mcVI$sp(s);
                    }

                    public void apply$mcVI$sp(int s) {
                        if (this.world$1.isAirBlock(this.pos$1.offset(EnumFacing.values()[s]))) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }
                    {
                        this.world$1 = world$1;
                        this.pos$1 = pos$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isBlockUnderTree(World world, BlockPos pos) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                if (world.canBlockSeeSky(pos)) {
                    return false;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(pos.getY()), world.getHeight()).foreach$mVc$sp((Function1)new Serializable(world, pos, object){
                    private final World world$3;
                    private final BlockPos pos$3;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int h) {
                        this.apply$mcVI$sp(h);
                    }

                    public void apply$mcVI$sp(int h) {
                        IBlockState b;
                        BlockPos pos2 = this.pos$3.up(h);
                        if (WorldLib$.MODULE$.isLeafType(this.world$3, pos2, b = this.world$3.getBlockState(pos2)) || WorldLib$.MODULE$.isAssociatedTreeBlock(this.world$3, pos2, b)) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, true);
                        }
                    }
                    {
                        this.world$3 = world$3;
                        this.pos$3 = pos$3;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public int getSkyLightValue(World world, BlockPos pos) {
        return world.getLightFor(EnumSkyBlock.SKY, pos) - world.getSkylightSubtracted();
    }

    public int getBlockLightValue(World w, BlockPos pos) {
        return w.getLightFor(EnumSkyBlock.BLOCK, pos);
    }

    private PerlinNoiseGenerator noise() {
        return this.noise;
    }

    /*
     * WARNING - void declaration
     */
    public double getWindSpeed(World world, BlockPos pos) {
        void var3_3;
        if (world.provider.isSurfaceWorld()) {
            return 0.5;
        }
        double nv = this.noise().noise((double)world.getWorldTime() * 8.5E-7, 0.0, 0.0, 5, 7.5, 5.0, true);
        nv = package$.MODULE$.max(0.0, 1.6 * (nv - 0.006) + 0.06) * package$.MODULE$.sqrt((double)pos.getY()) / 16.0;
        Biome bgb = world.getBiome(pos);
        if (bgb.canRain()) {
            if (world.isThundering()) {
                return 2.5 * nv;
            }
            if (world.isRaining()) {
                return 0.5 + 0.5 * nv;
            }
        }
        return (double)var3_3;
    }

    private WorldLib$() {
        MODULE$ = this;
        this.noise = new PerlinNoiseGenerator(2576710L);
    }
}

