/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.world;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.ServerUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mrtjp.core.world.IBlockEventHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import scala.Array$;
import scala.Predef$;
import scala.reflect.ClassTag$;

public final class BlockUpdateHandler$ {
    public static final BlockUpdateHandler$ MODULE$;
    private int updateLCG;
    private IBlockEventHandler[] handlers;
    private boolean registered;
    private HashSet<ChunkPos> chunkSet;

    static {
        new BlockUpdateHandler$();
    }

    private int updateLCG() {
        return this.updateLCG;
    }

    private void updateLCG_$eq(int x$1) {
        this.updateLCG = x$1;
    }

    private IBlockEventHandler[] handlers() {
        return this.handlers;
    }

    private void handlers_$eq(IBlockEventHandler[] x$1) {
        this.handlers = x$1;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    private HashSet<ChunkPos> chunkSet() {
        return this.chunkSet;
    }

    private void chunkSet_$eq(HashSet<ChunkPos> x$1) {
        this.chunkSet = x$1;
    }

    public void register(IBlockEventHandler handler) {
        if (!this.registered()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.registered_$eq(true);
        }
        this.handlers_$eq((IBlockEventHandler[])Predef$.MODULE$.refArrayOps((Object[])this.handlers()).$colon$plus((Object)handler, ClassTag$.MODULE$.apply(IBlockEventHandler.class)));
    }

    public Set<ChunkPos> getActiveChunkSet(World w) {
        this.chunkSet().clear();
        this.chunkSet().addAll((Collection<ChunkPos>)w.getPersistentChunks().keySet());
        for (int i = 0; i < w.playerEntities.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)w.playerEntities.get(i);
            int j = MathHelper.floor((double)(entityplayer.posX / 16.0));
            int k = MathHelper.floor((double)(entityplayer.posZ / 16.0));
            int l = ServerUtils.mc().getPlayerList().getViewDistance();
            for (int i1 = -l; i1 <= l; ++i1) {
                for (int j1 = -l; j1 <= l; ++j1) {
                    this.chunkSet().add(new ChunkPos(i1 + j, j1 + k));
                }
            }
        }
        return this.chunkSet();
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        Side side = event.side;
        Side side2 = Side.SERVER;
        if (!(side != null ? !side.equals(side2) : side2 != null)) {
            TickEvent.Phase phase = event.phase;
            TickEvent.Phase phase2 = TickEvent.Phase.END;
            if (!(phase != null ? !phase.equals(phase2) : phase2 != null)) {
                WorldServer world = (WorldServer)event.world;
                for (ChunkPos chunkPos : this.getActiveChunkSet((World)world)) {
                    Chunk chunk = world.getChunkFromChunkCoords(chunkPos.x, chunkPos.z);
                    ExtendedBlockStorage[] ebstorage = chunk.getBlockStorageArray();
                    for (int k = 0; k < ebstorage.length; ++k) {
                        ExtendedBlockStorage ebs = ebstorage[k];
                        if (ebs == null) continue;
                        for (int i = 0; i < 3; ++i) {
                            this.updateLCG_$eq(this.updateLCG() * 3 + 1013904223);
                            int i2 = this.updateLCG() >> 2;
                            int j2 = i2 & 0xF;
                            int k2 = i2 >> 8 & 0xF;
                            int l2 = i2 >> 16 & 0xF;
                            IBlockState block = ebs.get(j2, l2, k2);
                            for (int j = 0; j < this.handlers().length; ++j) {
                                BlockPos p = new BlockPos(j2 + chunk.x * 16, l2 + ebs.getYLocation(), k2 + chunk.z * 16);
                                this.handlers()[j].onBlockUpdate((World)world, p, block);
                            }
                        }
                    }
                }
                return;
            }
        }
    }

    private BlockUpdateHandler$() {
        MODULE$ = this;
        this.updateLCG = new Random().nextInt();
        this.handlers = (IBlockEventHandler[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(IBlockEventHandler.class));
        this.registered = false;
        this.chunkSet = new HashSet();
    }
}

