/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.math;

import codechicken.lib.vec.Vector3;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class MathLib$ {
    public static final MathLib$ MODULE$;
    private final Random random;

    static {
        new MathLib$();
    }

    public float clamp(float min, float max, float v) {
        return Math.min(max, Math.max(min, v));
    }

    public Tuple2<Object, Object> normal(BlockPos bc, int dir) {
        return this.normal(bc.getX(), bc.getY(), bc.getZ(), dir);
    }

    public Tuple2<Object, Object> normal(int x, int y, int z, int dir) {
        Tuple2.mcII.sp sp2;
        int n = dir;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 5: {
                sp2 = new Tuple2.mcII.sp(y, z);
                break;
            }
            case 4: {
                sp2 = new Tuple2.mcII.sp(y, z);
                break;
            }
            case 3: {
                sp2 = new Tuple2.mcII.sp(x, y);
                break;
            }
            case 2: {
                sp2 = new Tuple2.mcII.sp(x, y);
                break;
            }
            case 1: {
                sp2 = new Tuple2.mcII.sp(x, z);
                break;
            }
            case 0: {
                sp2 = new Tuple2.mcII.sp(x, z);
            }
        }
        return sp2;
    }

    public int basis(BlockPos bc, int dir) {
        return this.basis(bc.getX(), bc.getY(), bc.getZ(), dir);
    }

    public int basis(int x, int y, int z, int dir) {
        int n;
        int n2 = dir;
        switch (n2) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
            case 5: {
                n = x;
                break;
            }
            case 4: {
                n = x;
                break;
            }
            case 3: {
                n = z;
                break;
            }
            case 2: {
                n = z;
                break;
            }
            case 1: {
                n = y;
                break;
            }
            case 0: {
                n = y;
            }
        }
        return n;
    }

    public int shift(int dir) {
        return (dir & 1) == 1 ? 1 : -1;
    }

    public Seq<Tuple2<Object, Object>> splitLine(Seq<Object> xs, int shift) {
        Seq seq;
        if (xs.isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            IntRef start = IntRef.create((int)0);
            Seq ret = (Seq)((TraversableLike)xs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<Object, Object> x$1) {
                    Tuple2<Object, Object> tuple2 = x$1;
                    if (tuple2 != null) {
                        int i = tuple2._2$mcI$sp();
                        boolean bl = i > 0;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            }).withFilter((Function1)new Serializable(xs, shift){
                private final Seq xs$1;
                private final int shift$1;

                public final boolean apply(Tuple2<Object, Object> x$2) {
                    Tuple2<Object, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        int i;
                        int x = tuple2._1$mcI$sp();
                        boolean bl = x != BoxesRunTime.unboxToInt((Object)this.xs$1.apply((i = tuple2._2$mcI$sp()) - 1)) + this.shift$1;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.xs$1 = xs$1;
                    this.shift$1 = shift$1;
                }
            }).map((Function1)new Serializable(xs, start){
                private final Seq xs$1;
                private final IntRef start$1;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x$3) {
                    Tuple2<Object, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        int i = tuple2._2$mcI$sp();
                        int size = i - this.start$1.elem;
                        this.start$1.elem = i;
                        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)this.xs$1.apply(i - 1)), size);
                        return sp2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.xs$1 = xs$1;
                    this.start$1 = start$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            seq = (Seq)ret.$colon$plus((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)xs.last()), xs.length() - start.elem), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public BlockPos rhrAxis(int dir, Tuple2<Object, Object> normal, int basis) {
        BlockPos blockPos;
        int n = dir;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 5: {
                blockPos = new BlockPos(basis, normal._1$mcI$sp(), normal._2$mcI$sp());
                break;
            }
            case 4: {
                blockPos = new BlockPos(basis, normal._1$mcI$sp(), normal._2$mcI$sp());
                break;
            }
            case 3: {
                blockPos = new BlockPos(normal._1$mcI$sp(), normal._2$mcI$sp(), basis);
                break;
            }
            case 2: {
                blockPos = new BlockPos(normal._1$mcI$sp(), normal._2$mcI$sp(), basis);
                break;
            }
            case 1: {
                blockPos = new BlockPos(normal._1$mcI$sp(), basis, normal._2$mcI$sp());
                break;
            }
            case 0: {
                blockPos = new BlockPos(normal._1$mcI$sp(), basis, normal._2$mcI$sp());
            }
        }
        return blockPos;
    }

    public Vector3 bezier(Vector3 s, Vector3 c1, Vector3 c2, Vector3 e, float t) {
        if (t < 0.0f || t > 1.0f) {
            return s;
        }
        float one_minus_t = 1.0f - t;
        Vector3 retValue = new Vector3(0.0, 0.0, 0.0);
        Vector3[] terms = new Vector3[]{this.calcNewVector$1(one_minus_t * one_minus_t * one_minus_t, s), this.calcNewVector$1(3.0f * one_minus_t * one_minus_t * t, c1), this.calcNewVector$1(3.0f * one_minus_t * t * t, c2), this.calcNewVector$1(t * t * t, e)};
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1)new Serializable(retValue, terms){
            private final Vector3 retValue$1;
            private final Vector3[] terms$1;

            public final Vector3 apply(int i) {
                return this.retValue$1.add(this.terms$1[i]);
            }
            {
                this.retValue$1 = retValue$1;
                this.terms$1 = terms$1;
            }
        });
        return retValue;
    }

    private Random random() {
        return this.random;
    }

    public int randomFromIntRange(Range az, Random rand) {
        return az.apply$mcII$sp(rand.nextInt(az.size()));
    }

    public Random randomFromIntRange$default$2() {
        return this.random();
    }

    /*
     * WARNING - void declaration
     */
    public int leastSignificant(int mask) {
        void var2_2;
        int bit = 0;
        for (int m = mask; (m & 1) == 0 && m != 0; m <<= 1) {
            ++bit;
        }
        return (int)var2_2;
    }

    public int mostSignificant(int mask) {
        if (mask == 0) {
            return 0;
        }
        return 31 - Integer.numberOfLeadingZeros(mask);
    }

    public <T> T weightedRandom(Traversable<Tuple2<T, Object>> xs, Random rand) {
        if (xs.size() == 1) {
            return (T)((Tuple2)xs.head())._1();
        }
        IntRef weight = IntRef.create((int)rand.nextInt(BoxesRunTime.unboxToInt((Object)((TraversableOnce)xs.map((Function1)new Serializable(){

            public final int apply(Tuple2<T, Object> x$4) {
                return x$4._2$mcI$sp();
            }
        }, Traversable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
        return (T)((Tuple2)xs.find((Function1)new Serializable(weight){
            private final IntRef weight$1;

            public final boolean apply(Tuple2<T, Object> x) {
                this.weight$1.elem -= x._2$mcI$sp();
                return this.weight$1.elem < 0;
            }
            {
                this.weight$1 = weight$1;
            }
        }).get())._1();
    }

    public <T> Random weightedRandom$default$2() {
        return this.random();
    }

    private final Vector3 calcNewVector$1(float scaler, Vector3 base) {
        return base.copy().multiply((double)scaler);
    }

    private MathLib$() {
        MODULE$ = this;
        this.random = new Random();
    }
}

