/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.core.world;

import codechicken.lib.vec.BlockCoord;
import mrtjp.core.math.PerlinNoiseGenerator;
import mrtjp.core.world.WorldLib$;
import mrtjp.core.world.WorldLib$$anonfun$bulkBlockUpdate$1$;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.oredict.OreDictionary;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class WorldLib$ {
    public static final WorldLib$ MODULE$;
    private final PerlinNoiseGenerator noise;

    static {
        new WorldLib$();
    }

    public TileEntity getTileEntity(IBlockAccess w, BlockCoord bc) {
        return this.getTileEntity(w, bc, TileEntity.class);
    }

    public <T> T getTileEntity(IBlockAccess w, BlockCoord bc, Class<T> clazz) {
        return this.getTileEntity(w, bc.x, bc.y, bc.z, clazz);
    }

    public <T> T getTileEntity(IBlockAccess w, int x, int y, int z, Class<T> clazz) {
        TileEntity tile;
        return (T)(y < 0 ? null : (clazz.isInstance(tile = w.getTileEntity(x, y, z)) ? tile : null));
    }

    public Block getBlock(IBlockAccess w, BlockCoord bc) {
        return w.getBlock(bc.x, bc.y, bc.z);
    }

    public void bulkBlockUpdate(World w, int x, int y, int z, Block bl) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(w, x, y, z, bl){
            public final World w$1;
            public final int x$1;
            public final int y$1;
            public final int z$1;
            public final Block bl$1;

            public final void apply(int a) {
                this.apply$mcVI$sp(a);
            }

            public void apply$mcVI$sp(int a) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(this, a){
                    private final /* synthetic */ anonfun.bulkBlockUpdate.1 $outer;
                    public final int a$1;

                    public final void apply(int b) {
                        this.apply$mcVI$sp(b);
                    }

                    public void apply$mcVI$sp(int b) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-3), 3).foreach$mVc$sp((Function1)new Serializable(this, b){
                            private final /* synthetic */ anonfun$bulkBlockUpdate$1$$anonfun$apply$mcVI$sp$1 $outer;
                            private final int b$2;

                            public final void apply(int c) {
                                this.apply$mcVI$sp(c);
                            }

                            public void apply$mcVI$sp(int c) {
                                Block block;
                                int md = (this.$outer.a$1 < 0 ? -this.$outer.a$1 : this.$outer.a$1) + (this.b$2 < 0 ? -this.b$2 : this.b$2) + (c < 0 ? -c : c);
                                if (md <= 3 && (block = this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().w$1.getBlock(this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().x$1 + this.$outer.a$1, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().y$1 + this.b$2, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().z$1 + c)) != null) {
                                    block.onNeighborBlockChange(this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().w$1, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().x$1 + this.$outer.a$1, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().y$1 + this.b$2, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().z$1 + c, this.$outer.mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer().bl$1);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.b$2 = b$2;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.bulkBlockUpdate.1 mrtjp$core$world$WorldLib$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                    }
                });
            }
            {
                this.w$1 = w$1;
                this.x$1 = x$1;
                this.y$1 = y$1;
                this.z$1 = z$1;
                this.bl$1 = bl$1;
            }
        });
    }

    public void dropItem(World w, BlockCoord bc, ItemStack stack) {
        this.dropItem(w, bc.x, bc.y, bc.z, stack);
    }

    public void dropItem(World w, int x, int y, int z, ItemStack stack) {
        if (!w.isRemote && w.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            double d = 0.7;
            double dx = (double)w.rand.nextFloat() * d + (1.0 - d) * 0.5;
            double dy = (double)w.rand.nextFloat() * d + (1.0 - d) * 0.5;
            double dz = (double)w.rand.nextFloat() * d + (1.0 - d) * 0.5;
            EntityItem item = new EntityItem(w, (double)x + dx, (double)y + dy, (double)z + dz, stack);
            item.delayBeforeCanPickup = 10;
            w.spawnEntityInWorld((Entity)item);
        }
    }

    public void centerEject(World w, BlockCoord bc, ItemStack stack, int dir, double vel) {
        this.centerEject(w, bc.x, bc.y, bc.z, stack, dir, vel);
    }

    public void centerEject(World w, int x, int y, int z, ItemStack stack, int dir, double vel) {
        BlockCoord bc = new BlockCoord(x, y, z).offset(dir);
        EntityItem item = new EntityItem(w, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack);
        item.motionX = 0.0;
        item.motionY = 0.0;
        item.motionZ = 0.0;
        item.delayBeforeCanPickup = 10;
        int n = dir;
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 5: {
                item.motionX = vel;
                break;
            }
            case 4: {
                item.motionX = -vel;
                break;
            }
            case 3: {
                item.motionZ = vel;
                break;
            }
            case 2: {
                item.motionZ = -vel;
                break;
            }
            case 1: {
                item.motionY = vel;
                break;
            }
            case 0: {
                item.motionY = -vel;
            }
        }
        w.spawnEntityInWorld((Entity)item);
    }

    public long packCoords(BlockCoord bc) {
        return this.packCoords(bc.x, bc.y, bc.z);
    }

    public long packCoords(int x, int y, int z) {
        return (long)(x + 30000000) | (long)(z + 30000000) << 26 | (long)y << 52;
    }

    public int unpackX(long c) {
        return (int)(c & 0x3FFFFFFL) - 30000000;
    }

    public int unpackZ(long c) {
        return (int)(c >> 26 & 0x3FFFFFFL) - 30000000;
    }

    public int unpackY(long c) {
        return (int)(c >> 52 & 0xFFFL);
    }

    public BlockCoord unpackCoords(long c) {
        return new BlockCoord(this.unpackX(c), this.unpackY(c), this.unpackZ(c));
    }

    public void uncheckedSetBlock(World world, int x, int y, int z, Block block, int meta) {
        Chunk ch = world.getChunkFromBlockCoords(x, z);
        ExtendedBlockStorage[] arr = ch.getBlockStorageArray();
        if (arr[y >> 4] == null) {
            arr[y >> 4] = new ExtendedBlockStorage(y & ~15, !world.provider.hasNoSky);
        }
        arr[y >> 4].func_150818_a(x & 0xF, y & 0xF, z & 0xF, block);
        arr[y >> 4].setExtBlockMetadata(x & 0xF, y & 0xF, z & 0xF, meta);
        world.markBlockForUpdate(x, y, z);
    }

    public void uncheckedRemoveTileEntity(World world, int x, int y, int z) {
        Chunk ch = world.getChunkFromBlockCoords(x, z);
        ch.chunkTileEntityMap.remove(new ChunkPosition(x & 0xF, y, z & 0xF));
    }

    public void uncheckedSetTileEntity(World world, int x, int y, int z, TileEntity te) {
        Chunk ch = world.getChunkFromBlockCoords(x, z);
        ch.chunkTileEntityMap.put(new ChunkPosition(x & 0xF, y, z & 0xF), te);
    }

    public TileEntity uncheckedGetTileEntity(World world, int x, int y, int z) {
        Chunk ch = world.getChunkFromBlockCoords(x, z);
        return (TileEntity)ch.chunkTileEntityMap.get(new ChunkPosition(x & 0xF, y, z & 0xF));
    }

    public Tuple2<Block, Object> getBlockMetaPair(World world, int x, int y, int z) {
        return new Tuple2((Object)world.getBlock(x, y, z), (Object)BoxesRunTime.boxToInteger((int)world.getBlockMetadata(x, y, z)));
    }

    public Tuple3<Block, Object, TileEntity> getBlockInfo(World world, int x, int y, int z) {
        return new Tuple3((Object)world.getBlock(x, y, z), (Object)BoxesRunTime.boxToInteger((int)world.getBlockMetadata(x, y, z)), (Object)world.getTileEntity(x, y, z));
    }

    public boolean isLeafType(World world, int x, int y, int z, Block b) {
        return b.isLeaves((IBlockAccess)world, x, y, z) || Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)new ItemStack(b))).contains((Object)BoxesRunTime.boxToInteger((int)OreDictionary.getOreID((String)"treeLeaves")));
    }

    public boolean isPlantType(World world, int x, int y, int z, Block b) {
        Block block;
        Block block2 = b;
        boolean bl = block2 instanceof IGrowable ? !((block = block2) instanceof BlockGrass) : (block2 instanceof IPlantable ? true : b.isFoliage((IBlockAccess)world, x, y, z));
        return bl;
    }

    public boolean isBlockSoft(World world, int x, int y, int z, Block b) {
        return b.isAir((IBlockAccess)world, x, y, z) || b.isReplaceable((IBlockAccess)world, x, y, z) || this.isLeafType(world, x, y, z, b) || this.isPlantType(world, x, y, z, b) || b.canBeReplacedByLeaves((IBlockAccess)world, x, y, z);
    }

    public boolean isAssociatedTreeBlock(World world, int x, int y, int z, Block b) {
        return ((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Block[]{Blocks.log, Blocks.log2, Blocks.leaves, Blocks.leaves2, Blocks.vine, Blocks.cocoa}))).contains((Object)b) || this.isLeafType(world, x, y, z, b) || Predef$.MODULE$.intArrayOps(OreDictionary.getOreIDs((ItemStack)new ItemStack(b))).contains((Object)BoxesRunTime.boxToInteger((int)OreDictionary.getOreID((String)"logWood")));
    }

    public int findSurfaceHeight(World world, int x, int z) {
        Block b;
        int y = world.getHeightValue(x, z) + 1;
        while (--y >= 0 && (this.isBlockSoft(world, x, y, z, b = world.getBlock(x, y, z)) || this.isAssociatedTreeBlock(world, x, y, z, b))) {
        }
        return y;
    }

    public boolean isBlockTouchingAir(World world, BlockCoord b) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable(world, b, object){
                    private final World world$1;
                    private final BlockCoord b$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int s) {
                        this.apply$mcVI$sp(s);
                    }

                    public void apply$mcVI$sp(int s) {
                        BlockCoord bc = this.b$1.copy().offset(s);
                        if (this.world$1.isAirBlock(bc.x, bc.y, bc.z)) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                    }
                    {
                        this.world$1 = world$1;
                        this.b$1 = b$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isBlockUnderTree(World world, int x, int y, int z) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                if (world.canBlockSeeTheSky(x, y, z)) {
                    return false;
                }
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(y), world.getHeight()).foreach$mVc$sp((Function1)new Serializable(world, x, z, object){
                    private final World world$2;
                    private final int x$2;
                    private final int z$2;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(int h) {
                        this.apply$mcVI$sp(h);
                    }

                    public void apply$mcVI$sp(int h) {
                        Block b = this.world$2.getBlock(this.x$2, h, this.z$2);
                        if (WorldLib$.MODULE$.isLeafType(this.world$2, this.x$2, h, this.z$2, b) || WorldLib$.MODULE$.isAssociatedTreeBlock(this.world$2, this.x$2, h, this.z$2, b)) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, true);
                        }
                    }
                    {
                        this.world$2 = world$2;
                        this.x$2 = x$2;
                        this.z$2 = z$2;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public int getSkyLightValue(World w, int x, int y, int z) {
        return w.getSavedLightValue(EnumSkyBlock.Sky, x, y, z) - w.skylightSubtracted;
    }

    public int getBlockLightValue(World w, int x, int y, int z) {
        return w.getSavedLightValue(EnumSkyBlock.Block, x, y, z);
    }

    private PerlinNoiseGenerator noise() {
        return this.noise;
    }

    public double getWindSpeed(World w, int x, int y, int z) {
        if (w.provider.isHellWorld) {
            return 0.5;
        }
        double nv = this.noise().noise((double)w.getWorldTime() * 8.5E-7, 0.0, 0.0, 5, 7.5, 5.0, true);
        nv = package$.MODULE$.max(0.0, 1.6 * (nv - 0.006) + 0.06) * package$.MODULE$.sqrt((double)y) / 16.0;
        BiomeGenBase bgb = w.getBiomeGenForCoords(x, z);
        if (bgb.canSpawnLightningBolt()) {
            if (w.isThundering()) {
                return 2.5 * nv;
            }
            if (w.isRaining()) {
                return 0.5 + 0.5 * nv;
            }
        }
        return nv;
    }

    private WorldLib$() {
        MODULE$ = this;
        this.noise = new PerlinNoiseGenerator(2576710L);
    }
}

