/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.microblock.BlockMicroMaterial$;
import codechicken.microblock.IMicroMaterial;
import codechicken.microblock.ItemMicroPart;
import codechicken.microblock.ItemMicroPart$;
import codechicken.microblock.handler.MicroblockProxy$;
import codechicken.multipart.RedstoneInteractions$;
import codechicken.multipart.TMultiPart;
import java.util.List;
import mrtjp.core.world.Messenger$;
import mrtjp.projectred.ProjectRedCore$;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.ItemMultimeter;
import mrtjp.projectred.core.TSwitchPacket;
import mrtjp.projectred.core.libmc.PRLib$;
import mrtjp.projectred.transmission.FramedRedwirePart;
import mrtjp.projectred.transmission.IRedwireEmitter;
import mrtjp.projectred.transmission.IRedwirePart;
import mrtjp.projectred.transmission.WirePropagator$;
import mrtjp.projectred.transportation.RenderPipe$;
import mrtjp.projectred.transportation.SubcorePipePart;
import mrtjp.projectred.transportation.TRedstonePipe;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public abstract class TRedstonePipe$class {
    public static void save(TRedstonePipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$save(tag);
        tag.func_74757_a("mat", $this.hasRedstone());
        tag.func_74774_a("signal", $this.signal());
    }

    public static void load(TRedstonePipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$load(tag);
        $this.hasRedstone_$eq(tag.func_74767_n("mat"));
        $this.signal_$eq(tag.func_74771_c("signal"));
    }

    public static void writeDesc(TRedstonePipe $this, MCDataOutput packet) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$writeDesc(packet);
        packet.writeBoolean($this.hasRedstone());
        packet.writeByte((int)$this.signal());
    }

    public static void readDesc(TRedstonePipe $this, MCDataInput packet) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$readDesc(packet);
        $this.hasRedstone_$eq(packet.readBoolean());
        $this.signal_$eq(packet.readByte());
    }

    public static void read(TRedstonePipe $this, MCDataInput packet, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$transportation$TRedstonePipe$$super$read(packet, key);
                break;
            }
            case 3: {
                $this.signal_$eq(packet.readByte());
                ((TMultiPart)$this).tile().markRender();
                break;
            }
            case 2: {
                $this.hasRedstone_$eq(packet.readBoolean());
                ((TMultiPart)$this).tile().markRender();
            }
        }
    }

    public static void sendMatUpdate(TRedstonePipe $this) {
        if (!((TMultiPart)$this).world().field_72995_K) {
            if ($this.updateInward()) {
                ((SubcorePipePart)((Object)$this)).onMaskChanged();
            }
            WirePropagator$.MODULE$.propagateTo($this, 2);
        }
        ((TSwitchPacket)((Object)$this)).getWriteStreamOf(2).writeBoolean($this.hasRedstone());
    }

    public static void onSignalUpdate(TRedstonePipe $this) {
        ((TMultiPart)$this).tile().func_70296_d();
        ((TSwitchPacket)((Object)$this)).getWriteStreamOf(3).writeByte((int)$this.signal());
    }

    public static void onPartChanged(TRedstonePipe $this, TMultiPart part) {
        if (!((TMultiPart)$this).world().field_72995_K) {
            WirePropagator$.MODULE$.logCalculation();
            if ($this.updateOutward()) {
                ((SubcorePipePart)((Object)$this)).onMaskChanged();
                WirePropagator$.MODULE$.propagateTo($this, 2);
            } else {
                WirePropagator$.MODULE$.propagateTo($this, 0);
            }
        }
    }

    public static void onNeighborChanged(TRedstonePipe $this) {
        if (!((TMultiPart)$this).world().field_72995_K) {
            WirePropagator$.MODULE$.logCalculation();
            if ($this.updateExternalConns()) {
                ((SubcorePipePart)((Object)$this)).onMaskChanged();
                WirePropagator$.MODULE$.propagateTo($this, 2);
            } else {
                WirePropagator$.MODULE$.propagateTo($this, 0);
            }
        }
    }

    public static void onAdded(TRedstonePipe $this) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$onAdded();
        if (!((TMultiPart)$this).world().field_72995_K) {
            if ($this.updateInward()) {
                ((SubcorePipePart)((Object)$this)).onMaskChanged();
            }
            WirePropagator$.MODULE$.propagateTo($this, 0);
        }
    }

    public static List getDrops(TRedstonePipe $this) {
        return $this.hasRedstone() ? JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer($this.mrtjp$projectred$transportation$TRedstonePipe$$super$getDrops()).$colon$plus((Object)$this.getMaterialStack(), Buffer$.MODULE$.canBuildFrom())) : $this.mrtjp$projectred$transportation$TRedstonePipe$$super$getDrops();
    }

    public static ItemStack getMaterialStack(TRedstonePipe $this) {
        return ItemMicroPart$.MODULE$.create(769, BlockMicroMaterial$.MODULE$.materialKey(Blocks.field_150451_bX.func_176223_P()));
    }

    public static boolean diminishOnSide(TRedstonePipe $this, int side) {
        return true;
    }

    public static int strongPowerLevel(TRedstonePipe $this, int side) {
        return 0;
    }

    public static int weakPowerLevel(TRedstonePipe $this, int side) {
        return $this.maskConnects(side) && $this.hasRedstone() ? $this.rsLevel() : 0;
    }

    public static boolean canConnectRedstone(TRedstonePipe $this, int side) {
        return $this.hasRedstone();
    }

    public static int getConnectionMask(TRedstonePipe $this, int side) {
        return 16;
    }

    public static boolean canConnectPart(TRedstonePipe $this, IConnectable part, int s) {
        IConnectable iConnectable = part;
        boolean bl = iConnectable instanceof FramedRedwirePart && $this.hasRedstone() ? true : $this.mrtjp$projectred$transportation$TRedstonePipe$$super$canConnectPart(part, s);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean discoverStraightOverride(TRedstonePipe $this, int absDir) {
        boolean bl;
        if ($this.hasRedstone()) {
            void var2_2;
            WirePropagator$.MODULE$.setRedwiresConnectable(false);
            boolean b = (RedstoneInteractions$.MODULE$.otherConnectionMask((IBlockAccess)((TMultiPart)$this).world(), ((TMultiPart)$this).pos(), absDir, false) & RedstoneInteractions$.MODULE$.connectionMask((TMultiPart)$this, absDir)) != 0;
            WirePropagator$.MODULE$.setRedwiresConnectable(true);
            bl = var2_2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static int rsLevel(TRedstonePipe $this) {
        return WirePropagator$.MODULE$.redwiresProvidePower() ? (($this.signal() & 0xFF) + 16) / 17 : 0;
    }

    public static int getRedwireSignal(TRedstonePipe $this, int side) {
        return $this.getSignal();
    }

    public static int getSignal(TRedstonePipe $this) {
        return $this.signal() & 0xFF;
    }

    public static void setSignal(TRedstonePipe $this, int sig) {
        $this.signal_$eq((byte)sig);
    }

    public static void propagateOther(TRedstonePipe $this, int mode) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this){
            private final /* synthetic */ TRedstonePipe $outer;

            public final void apply(int s) {
                this.apply$mcVI$sp(s);
            }

            public void apply$mcVI$sp(int s) {
                if (!this.$outer.maskConnects(s)) {
                    WirePropagator$.MODULE$.addNeighborChange(this.$outer.posOfStraight(s));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static int calculateSignal(TRedstonePipe $this) {
        if ($this.hasRedstone()) {
            WirePropagator$.MODULE$.setDustProvidePower(false);
            WirePropagator$.MODULE$.redwiresProvidePower_$eq(false);
            IntRef s = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, s){
                private final /* synthetic */ TRedstonePipe $outer;
                private final IntRef s$1;

                public final void apply(int s) {
                    this.apply$mcVI$sp(s);
                }

                public void apply$mcVI$sp(int s) {
                    if (this.$outer.maskConnectsOut(s)) {
                        TRedstonePipe$class.raise$1(this.$outer, this.$outer.calcStraightSignal(s), this.s$1);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.s$1 = s$1;
                }
            });
            WirePropagator$.MODULE$.setDustProvidePower(true);
            WirePropagator$.MODULE$.redwiresProvidePower_$eq(true);
            return s.elem;
        }
        return 0;
    }

    public static int calcStraightSignal(TRedstonePipe $this, int s) {
        int n;
        TMultiPart tMultiPart = $this.getStraight(s);
        if (tMultiPart != null) {
            TMultiPart tMultiPart2 = tMultiPart;
            n = $this.resolveSignal(tMultiPart2, s ^ 1);
        } else {
            n = $this.calcStrongSignal(s);
        }
        return n;
    }

    public static int resolveSignal(TRedstonePipe $this, Object part, int s) {
        int n;
        IRedwirePart iRedwirePart;
        Object object = part;
        if (object instanceof IRedwirePart && (iRedwirePart = (IRedwirePart)object).diminishOnSide(s)) {
            n = iRedwirePart.getRedwireSignal(s) - 1;
        } else if (object instanceof IRedwireEmitter) {
            IRedwireEmitter iRedwireEmitter = (IRedwireEmitter)object;
            n = iRedwireEmitter.getRedwireSignal(s);
        } else {
            n = 0;
        }
        return n;
    }

    public static boolean activate(TRedstonePipe $this, EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        if ($this.mrtjp$projectred$transportation$TRedstonePipe$$super$activate(player, hit, item, hand)) {
            return true;
        }
        if (item != null) {
            Item item2 = item.func_77973_b();
            ItemMultimeter itemMultimeter = ProjectRedCore$.MODULE$.itemMultimeter();
            if (!(item2 != null ? !item2.equals((Object)itemMultimeter) : itemMultimeter != null)) {
                item.func_77972_a(1, (EntityLivingBase)player);
                $this.test(player);
                return true;
            }
        }
        if (item == null && player.func_70093_af() && $this.hasRedstone()) {
            if (!((TMultiPart)$this).world().field_72995_K) {
                if ($this.hasRedstone() && !player.field_71075_bZ.field_75098_d) {
                    PRLib$.MODULE$.dropTowardsPlayer(((TMultiPart)$this).world(), ((TMultiPart)$this).pos(), $this.getMaterialStack(), player);
                }
                $this.hasRedstone_$eq(false);
                $this.sendMatUpdate();
            }
            return true;
        }
        if (item != null && !$this.hasRedstone()) {
            Item item3 = item.func_77973_b();
            ItemMicroPart itemMicroPart = MicroblockProxy$.MODULE$.itemMicro();
            if (!(item3 != null ? !item3.equals(itemMicroPart) : itemMicroPart != null) && item.func_77952_i() == 769) {
                IMicroMaterial iMicroMaterial = ItemMicroPart$.MODULE$.getMaterial(item);
                if (iMicroMaterial instanceof BlockMicroMaterial) {
                    BlockMicroMaterial blockMicroMaterial = (BlockMicroMaterial)iMicroMaterial;
                    Block block = blockMicroMaterial.state().func_177230_c();
                    Block block2 = Blocks.field_150451_bX;
                    if (!(block != null ? !block.equals(block2) : block2 != null)) {
                        if (!((TMultiPart)$this).world().field_72995_K) {
                            $this.hasRedstone_$eq(true);
                            ((TMultiPart)$this).world().func_184133_a(null, ((TMultiPart)$this).pos(), SoundType.field_185853_f.func_185841_e(), SoundCategory.BLOCKS, SoundType.field_185853_f.func_185843_a(), SoundType.field_185853_f.func_185847_b());
                            $this.sendMatUpdate();
                            if (!player.field_71075_bZ.field_75098_d) {
                                --item.field_77994_a;
                            }
                        }
                        return true;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return false;
    }

    public static boolean debug(TRedstonePipe $this, EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentString(new StringBuilder().append((Object)(((TMultiPart)$this).world().field_72995_K ? "Client" : "Server")).append((Object)" signal strength: ").append((Object)BoxesRunTime.boxToInteger((int)$this.getSignal())).toString()));
        return true;
    }

    public static boolean test(TRedstonePipe $this, EntityPlayer player) {
        if (((TMultiPart)$this).world().field_72995_K) {
            Messenger$.MODULE$.addMessage((double)((TMultiPart)$this).x(), (double)((float)((TMultiPart)$this).y() + 0.5f), (double)((TMultiPart)$this).z(), new StringBuilder().append((Object)"/#f/#c[c] = ").append((Object)BoxesRunTime.boxToInteger((int)$this.getSignal())).toString());
        } else {
            PacketCustom packet = Messenger$.MODULE$.createPacket();
            packet.writeDouble((double)((TMultiPart)$this).x() + 0.0);
            packet.writeDouble((double)((TMultiPart)$this).y() + 0.5);
            packet.writeDouble((double)((TMultiPart)$this).z() + 0.0);
            packet.writeString(new StringBuilder().append((Object)"/#c[s] = ").append((Object)BoxesRunTime.boxToInteger((int)$this.getSignal())).toString());
            packet.sendToPlayer(player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void doStaticTessellation(TRedstonePipe $this, Vector3 pos, CCRenderState ccrs) {
        $this.mrtjp$projectred$transportation$TRedstonePipe$$super$doStaticTessellation(pos, ccrs);
        if ($this.hasRedstone()) {
            RenderPipe$.MODULE$.renderRSWiring($this, pos, $this.signal(), ccrs);
        }
    }

    public static final void raise$1(TRedstonePipe $this, int sig, IntRef s$1) {
        if (sig > s$1.elem) {
            s$1.elem = sig;
        }
    }

    public static void $init$(TRedstonePipe $this) {
        $this.signal_$eq((byte)0);
        $this.hasRedstone_$eq(false);
    }
}

