/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred;

import mrtjp.core.data.ModConfig;
import mrtjp.projectred.relocation.MovingTileRegistry$;
import mrtjp.projectred.relocation.StickRegistry$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class RelocationConfig$
extends ModConfig {
    public static final RelocationConfig$ MODULE$;
    private int moveLimit;
    private String[] moverMap;
    private String[] setMap;

    static {
        new RelocationConfig$();
    }

    public int moveLimit() {
        return this.moveLimit;
    }

    public void moveLimit_$eq(int x$1) {
        this.moveLimit = x$1;
    }

    public String[] moverMap() {
        return this.moverMap;
    }

    public void moverMap_$eq(String[] x$1) {
        this.moverMap = x$1;
    }

    public String[] setMap() {
        return this.setMap;
    }

    public void setMap_$eq(String[] x$1) {
        this.setMap = x$1;
    }

    public String getFileName() {
        return "ProjectRedRelocation";
    }

    public void initValues() {
        ModConfig.BaseCategory general = new ModConfig.BaseCategory((ModConfig)this, "General", "Basic settings");
        this.moveLimit_$eq(BoxesRunTime.unboxToInt((Object)general.put("moveLimit", (Object)BoxesRunTime.boxToInteger((int)this.moveLimit()), "Maximum amount of blocks that can be moved at once.")));
        ModConfig.BaseCategory movers = new ModConfig.BaseCategory((ModConfig)this, "Tile Movers", this.buildMoverDesc());
        this.moverMap_$eq((String[])movers.put("mover registry", (Object)this.moverMap(), movers.put$default$3()));
        this.moverMap_$eq((String[])movers.put("mover registry", (Object)MovingTileRegistry$.MODULE$.parseAndSetMovers((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.moverMap())), true));
        ModConfig.BaseCategory sets = new ModConfig.BaseCategory((ModConfig)this, "Latched Sets", this.buildLatchSetsDesc());
        this.setMap_$eq((String[])sets.put("latch registry", (Object)this.setMap(), sets.put$default$3()));
        this.setMap_$eq((String[])sets.put("latch registry", (Object)StickRegistry$.MODULE$.parseAndAddLatchSets((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.setMap())), true));
    }

    public String buildMoverDesc() {
        ObjectRef s = ObjectRef.create((Object)new StringOps(Predef$.MODULE$.augmentString("Used to configure which registered Tile Mover is used for a block. Key-Value pairs are defined using\n              |the syntax key -> value.\n              |Most blocks are configurable, but some mods may have opted to lock which handlers can be used for its\n              |blocks.\n              |Possible keys:\n              |    'default' - to assign default handler.\n              |    mod:<modID>' - to assign every block from a mod.\n              |    <modID>:<blockname>' - to assign block from a mod for every meta.\n              |    <modID>:<blockname>m<meta>' - to assign block from mod for specific meta.\n            ")).stripMargin());
        s.elem = new StringBuilder().append((Object)((String)s.elem)).append((Object)"\nAvailable tile movers:\n").toString();
        MovingTileRegistry$.MODULE$.moverDescMap().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(s){
            private final ObjectRef s$1;

            public final void apply(Tuple2<String, String> x$1) {
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.s$1.elem = new StringBuilder().append((Object)((String)this.s$1.elem)).append((Object)new StringBuilder().append((Object)"    '").append((Object)k).append((Object)"' - ").append((Object)v).append((Object)"\n").toString()).toString();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.s$1 = s$1;
            }
        });
        if (MovingTileRegistry$.MODULE$.mandatoryMovers().nonEmpty()) {
            s.elem = new StringBuilder().append((Object)((String)s.elem)).append((Object)"\nMovers locked via API:\n").toString();
            MovingTileRegistry$.MODULE$.mandatoryMovers().withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(s){
                private final ObjectRef s$1;

                public final void apply(Tuple2<String, String> x$2) {
                    Tuple2<String, String> tuple2 = x$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        this.s$1.elem = new StringBuilder().append((Object)((String)this.s$1.elem)).append((Object)new StringBuilder().append((Object)"    ").append((Object)k).append((Object)" -> ").append((Object)v).append((Object)"\n").toString()).toString();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.s$1 = s$1;
                }
            });
        }
        return (String)s.elem;
    }

    public String buildLatchSetsDesc() {
        return new StringOps(Predef$.MODULE$.augmentString("Used to define which pairs of blocks will be stuck together.\n          |Latched sets will always move in pairs, even if only one of them are actually connected to a frame.\n          |'block1 -> block2' means that if block1 is moved, any block2 connected to it will also move.\n          |However, moving block2 does not move block1. To do that, you must also register block2 -> block1.\n          |Sets are defined using the syntax of key -> value.\n          |Possible keys and values:\n          |    '<modID>:<blockname>' - to assign block from a mod for every meta.\n          |    '<modID>:<blockname>#<property>=<value>[,<property>=<value>[,\u2026]]' - to assign block from mod with only the given properties matching.\n        ")).stripMargin();
    }

    private RelocationConfig$() {
        super("projectred-relocation");
        MODULE$ = this;
        this.moveLimit = 2048;
        this.moverMap = (String[])((Object[])new String[]{"default -> saveload"});
        this.setMap = (String[])((Object[])new String[]{"minecraft:bed -> minecraft:bed", "minecraft:wooden_door -> minecraft:wooden_door", "minecraft:iron_door -> minecraft:iron_door"});
    }
}

