/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.network;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.network.IPacketSender;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Packet {
    private final int m_channel;
    private final int m_replyChannel;
    private final Object m_payload;
    private final IPacketSender m_sender;

    public Packet(int channel, int replyChannel, @Nullable Object payload, @Nonnull IPacketSender sender) {
        Preconditions.checkNotNull((Object)sender, (Object)"sender cannot be null");
        this.m_channel = channel;
        this.m_replyChannel = replyChannel;
        this.m_payload = payload;
        this.m_sender = sender;
    }

    public int getChannel() {
        return this.m_channel;
    }

    public int getReplyChannel() {
        return this.m_replyChannel;
    }

    @Nullable
    public Object getPayload() {
        return this.m_payload;
    }

    @Nonnull
    public IPacketSender getSender() {
        return this.m_sender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Packet packet = (Packet)o;
        if (this.m_channel != packet.m_channel) {
            return false;
        }
        if (this.m_replyChannel != packet.m_replyChannel) {
            return false;
        }
        if (this.m_payload != null ? !this.m_payload.equals(packet.m_payload) : packet.m_payload != null) {
            return false;
        }
        return this.m_sender.equals(packet.m_sender);
    }

    public int hashCode() {
        int result2 = this.m_channel;
        result2 = 31 * result2 + this.m_replyChannel;
        result2 = 31 * result2 + (this.m_payload != null ? this.m_payload.hashCode() : 0);
        result2 = 31 * result2 + this.m_sender.hashCode();
        return result2;
    }
}

