/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessOreNBTCopyRecipe
extends ShapelessOreRecipe {
    private ItemStack output;

    public ShapelessOreNBTCopyRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result2) {
        super(group, input, result2);
        this.output = result2.copy();
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack out = this.output.copy();
        ItemStack oldItemWithNBT = ItemStack.EMPTY;
        for (int i = 0; i < 9; ++i) {
            ItemStack slot = inv.getStackInSlot(i);
            if (slot.isEmpty() || !slot.hasTagCompound()) continue;
            oldItemWithNBT = slot;
            break;
        }
        if (!oldItemWithNBT.isEmpty()) {
            out.setTagCompound(oldItemWithNBT.getTagCompound());
        }
        return out;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.getString((JsonObject)json, (String)"group", (String)"");
            NonNullList ings = NonNullList.create();
            for (JsonElement ele : JsonUtils.getJsonArray((JsonObject)json, (String)"ingredients")) {
                ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
            }
            if (ings.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.getJsonObject((JsonObject)json, (String)"result"), (JsonContext)context);
            return new ShapelessOreNBTCopyRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ings, itemstack);
        }
    }
}

