/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.map.IMapRenderer;
import codechicken.lib.texture.TextureUtils;
import mrtjp.core.vec.Point;
import mrtjp.core.vec.Point$;
import mrtjp.core.vec.Size;
import mrtjp.projectred.fabrication.ICTileMapContainer;
import mrtjp.projectred.fabrication.ItemICBlueprint;
import mrtjp.projectred.fabrication.ItemICBlueprint$;
import mrtjp.projectred.fabrication.RenderICTileMap$;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import scala.math.package$;

public final class ItemRenderICBlueprint$
implements IMapRenderer {
    public static final ItemRenderICBlueprint$ MODULE$;
    private final ResourceLocation background;

    static {
        new ItemRenderICBlueprint$();
    }

    public ResourceLocation background() {
        return this.background;
    }

    public boolean shouldHandle(ItemStack stack, boolean inFrame) {
        return stack.getItem() instanceof ItemICBlueprint;
    }

    public void renderMap(ItemStack stack, boolean inFrame) {
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.startDrawing(7, DefaultVertexFormats.POSITION_TEX);
        if (inFrame) {
            ICTileMapContainer tm;
            GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scale((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
            GlStateManager.translate((float)-64.0f, (float)-64.0f, (float)0.0f);
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)-1.0f);
            this.overlayBlueprintBackground(ccrs, 0.0);
            if (ItemICBlueprint$.MODULE$.hasICInside(stack) && (tm = ItemICBlueprint$.MODULE$.loadTileMap(stack)).nonEmpty()) {
                this.overlayTiles(ccrs, tm);
                this.overlayName(ccrs, tm.name(), 0.0, 122.0);
            }
        } else {
            ICTileMapContainer tm;
            GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scale((float)0.38f, (float)0.38f, (float)0.38f);
            GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)0.0f);
            GlStateManager.scale((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
            this.overlayBlueprintBackground(ccrs, 7.0);
            if (ItemICBlueprint$.MODULE$.hasICInside(stack) && (tm = ItemICBlueprint$.MODULE$.loadTileMap(stack)).nonEmpty()) {
                this.overlayTiles(ccrs, tm);
                this.overlayName(ccrs, tm.name(), 0.0, 128.0);
            }
        }
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.popMatrix();
    }

    private void overlayBlueprintBackground(CCRenderState ccrs, double expand) {
        TextureUtils.changeTexture((ResourceLocation)this.background());
        BufferBuilder buffer = ccrs.getBuffer();
        buffer.pos(0.0 - expand, (double)128 + expand, 0.0).tex(0.0, 1.0).endVertex();
        buffer.pos((double)128 + expand, (double)128 + expand, 0.0).tex(1.0, 1.0).endVertex();
        buffer.pos((double)128 + expand, 0.0 - expand, 0.0).tex(1.0, 0.0).endVertex();
        buffer.pos(0.0 - expand, 0.0 - expand, 0.0).tex(0.0, 0.0).endVertex();
        ccrs.draw();
    }

    private void overlayTiles(CCRenderState ccrs, ICTileMapContainer tm) {
        int sf = 128 / package$.MODULE$.max(tm.size().width(), tm.size().height());
        Size rs = tm.size().$times(sf);
        Point rp = Point$.MODULE$.apply(new Size(128, 128).$div(2).$minus(rs.$div(2)));
        RenderICTileMap$.MODULE$.renderOrtho(ccrs, tm, rp.x(), rp.y(), rs.width(), rs.height(), 0.0f);
    }

    private void overlayName(CCRenderState ccrs, String name, double x, double y) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)0.0);
        GlStateManager.scale((double)0.55, (double)0.55, (double)1.0);
        GuiDraw.drawRect((int)0, (int)0, (int)(GuiDraw.getStringWidth((String)name) + 4), (int)11, (int)0x5F000000);
        GuiDraw.drawString((String)name, (int)2, (int)2, (int)EnumColour.WHITE.argb(), (boolean)false);
        GlStateManager.popMatrix();
    }

    private ItemRenderICBlueprint$() {
        MODULE$ = this;
        this.background = new ResourceLocation("projectred", "textures/gui/map_background.png");
    }
}

