/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart$;
import java.util.List;
import mrtjp.projectred.ProjectRedCore$;
import mrtjp.projectred.core.Configurator$;
import mrtjp.projectred.core.ItemMultimeter;
import mrtjp.projectred.core.WirePropagator$;
import mrtjp.projectred.transmission.TWireCommons;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;

public abstract class TWireCommons$class {
    public static void preparePlacement(TWireCommons $this, int side, int meta) {
    }

    public static void onPartChanged(TWireCommons $this, TMultiPart part) {
        if (!((TMultiPart)$this).world().isRemote) {
            WirePropagator$.MODULE$.logCalculation();
            if ($this.updateOutward()) {
                $this.onMaskChanged();
                WirePropagator$.MODULE$.propagateTo($this, 2);
            } else {
                WirePropagator$.MODULE$.propagateTo($this, 0);
            }
        }
    }

    public static void onNeighborChanged(TWireCommons $this) {
        if (!((TMultiPart)$this).world().isRemote) {
            if ($this.dropIfCantStay()) {
                return;
            }
            WirePropagator$.MODULE$.logCalculation();
            if ($this.updateExternalConns()) {
                $this.onMaskChanged();
                WirePropagator$.MODULE$.propagateTo($this, 2);
            } else {
                WirePropagator$.MODULE$.propagateTo($this, 0);
            }
        }
    }

    public static void onAdded(TWireCommons $this) {
        $this.mrtjp$projectred$transmission$TWireCommons$$super$onAdded();
        if (!((TMultiPart)$this).world().isRemote) {
            if ($this.updateInward()) {
                $this.onMaskChanged();
            }
            WirePropagator$.MODULE$.propagateTo($this, 0);
        }
    }

    public static void onRemoved(TWireCommons $this) {
        $this.mrtjp$projectred$transmission$TWireCommons$$super$onRemoved();
        if (!((TMultiPart)$this).world().isRemote) {
            $this.notifyAllExternals();
        }
    }

    public static void onMaskChanged(TWireCommons $this) {
        $this.sendConnUpdate();
    }

    public static boolean dropIfCantStay(TWireCommons $this) {
        boolean bl;
        if ($this.canStay()) {
            bl = false;
        } else {
            $this.drop();
            bl = true;
        }
        return bl;
    }

    public static void drop(TWireCommons $this) {
        TileMultipart$.MODULE$.dropItem($this.getItem(), ((TMultiPart)$this).world(), Vector3.fromTileCenter((TileEntity)((TMultiPart)$this).tile()));
        ((TMultiPart)$this).tile().remPart((TMultiPart)$this);
    }

    public static int getThickness(TWireCommons $this) {
        return $this.getWireType().thickness();
    }

    public static List getDrops(TWireCommons $this) {
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ItemStack[]{$this.getItem()})));
    }

    public static ItemStack pickItem(TWireCommons $this, CuboidRayTraceResult hit) {
        return $this.getItem();
    }

    public static void onSignalUpdate(TWireCommons $this) {
        ((TMultiPart)$this).tile().markDirty();
    }

    public static boolean diminishOnSide(TWireCommons $this, int side) {
        return true;
    }

    public static boolean debug(TWireCommons $this, EntityPlayer player) {
        return false;
    }

    public static boolean test(TWireCommons $this, EntityPlayer player) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean activate(TWireCommons $this, EntityPlayer player, CuboidRayTraceResult hit, ItemStack held, EnumHand hand) {
        if (held.isEmpty()) return false;
        Item item = held.getItem();
        ItemMultimeter itemMultimeter = ProjectRedCore$.MODULE$.itemMultimeter();
        if (item == null) {
            if (itemMultimeter != null) {
                return false;
            }
        } else if (!item.equals((Object)itemMultimeter)) return false;
        held.damageItem(1, (EntityLivingBase)player);
        player.swingArm(hand);
        boolean bl = $this.test(player);
        return bl;
    }

    public static int renderHue(TWireCommons $this) {
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getIcon(TWireCommons $this) {
        return $this.getWireType().wireSprites()[0];
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderStatic(TWireCommons $this, Vector3 pos, BlockRenderLayer layer, CCRenderState ccrs) {
        boolean bl;
        BlockRenderLayer blockRenderLayer = layer;
        BlockRenderLayer blockRenderLayer2 = $this.getRenderLayer();
        if (!(blockRenderLayer != null ? !blockRenderLayer.equals(blockRenderLayer2) : blockRenderLayer2 != null) && $this.useStaticRenderer()) {
            ccrs.setBrightness((IBlockAccess)((TMultiPart)$this).world(), ((TMultiPart)$this).pos());
            $this.doStaticTessellation(pos, layer, ccrs);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderFast(TWireCommons $this, CCRenderState ccrs, Vector3 pos, int pass, float frame) {
        $this.doFastTessellation(pos, frame, pass, ccrs);
    }

    public static boolean canRenderFast(TWireCommons $this, int pass) {
        return pass == 0 && !$this.useStaticRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBreaking(TWireCommons $this, Vector3 pos, TextureAtlasSprite texture, CCRenderState ccrs) {
        ccrs.reset();
        $this.doBreakTessellation(pos, texture, ccrs);
    }

    @SideOnly(value=Side.CLIENT)
    public static BlockRenderLayer getRenderLayer(TWireCommons $this) {
        return BlockRenderLayer.SOLID;
    }

    public static boolean useStaticRenderer(TWireCommons $this) {
        return Configurator$.MODULE$.staticWires();
    }

    public static void $init$(TWireCommons $this) {
    }
}

