/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.MathHelper;

public class ParticleLogicApproachEntity
extends ParticleLogic {
    private final Entity target;
    private final double approachSpeed;
    private final double targetDistance;

    public ParticleLogicApproachEntity(Entity approachEntity, double approachSpeed, double targetDistance) {
        this.target = approachEntity;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        if (this.target == null) {
            this.finishLogic();
            return;
        }
        double distanceToTarget = this.particle.getDistanceSqToEntity(this.target);
        double deltaX = this.target.posX - this.particle.posX;
        double deltaZ = this.target.posZ - this.particle.posZ;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.posX + this.approachSpeed * Math.cos(radians);
        double posY = this.particle.posY;
        double posZ = this.particle.posZ + this.approachSpeed * Math.sin(radians);
        if (this.target instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.target;
            deltaY = posY - (entityliving.posY + (double)entityliving.getEyeHeight());
        } else {
            deltaY = this.target instanceof EntityItem ? posY - this.target.posY : (this.target.boundingBox.minY + this.target.boundingBox.maxY) / 2.0 - posY;
        }
        double horizontalDistance = MathHelper.sqrt_double((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.posY - this.approachSpeed * Math.sin(pitchRadians);
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.finishLogic();
        } else {
            this.particle.setPosition(posX, posY, posZ);
        }
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachEntity(this.target, this.approachSpeed, this.targetDistance).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

