/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import mrtjp.core.block.InstancedBlockTile;
import mrtjp.core.block.TTileOrient;
import mrtjp.core.inventory.InvWrapper;
import mrtjp.core.inventory.InvWrapper$;
import mrtjp.core.item.ItemKeyStack;
import mrtjp.core.world.WorldLib$;
import mrtjp.projectred.core.libmc.PRLib$;
import mrtjp.projectred.expansion.ItemStorage;
import mrtjp.projectred.expansion.TActiveDevice;
import mrtjp.projectred.transportation.PressurePayload;
import mrtjp.projectred.transportation.TPressureTube;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import scala.runtime.BoxedUnit;

public abstract class TActiveDevice$class {
    public static void save(TActiveDevice $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$save(tag);
        tag.setBoolean("pow", $this.powered());
        tag.setBoolean("act", $this.active());
        $this.storage().save(tag);
    }

    public static void load(TActiveDevice $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$load(tag);
        $this.powered_$eq(tag.getBoolean("pow"));
        $this.active_$eq(tag.getBoolean("act"));
        $this.storage().load(tag);
    }

    public static void writeDesc(TActiveDevice $this, MCDataOutput out) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$writeDesc(out);
        out.writeBoolean($this.powered()).writeBoolean($this.active());
    }

    public static void readDesc(TActiveDevice $this, MCDataInput in) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$readDesc(in);
        $this.powered_$eq(in.readBoolean());
        $this.active_$eq(in.readBoolean());
    }

    public static void read(TActiveDevice $this, MCDataInput in, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$expansion$TActiveDevice$$super$read(in, key);
                break;
            }
            case 4: {
                $this.powered_$eq(in.readBoolean());
                $this.active_$eq(in.readBoolean());
                ((InstancedBlockTile)$this).markRender();
            }
        }
    }

    public static void sendStateUpdate(TActiveDevice $this) {
        ((InstancedBlockTile)$this).streamToSend(((InstancedBlockTile)$this).writeStream(4).writeBoolean($this.powered()).writeBoolean($this.active())).sendToChunk();
    }

    public static boolean shouldAcceptBacklog(TActiveDevice $this) {
        return true;
    }

    public static boolean shouldAcceptInput(TActiveDevice $this) {
        return !$this.powered() && $this.storage().isEmpty();
    }

    public static void onScheduledTick(TActiveDevice $this) {
        if (!((InstancedBlockTile)$this).world().isRemote) {
            if ($this.storage().isEmpty()) {
                if (!$this.powered()) {
                    $this.active_$eq(false);
                    $this.onDeactivate();
                    $this.sendStateUpdate();
                }
            } else {
                $this.exportBuffer();
                ((InstancedBlockTile)$this).scheduleTick($this.storage().isEmpty() ? 4 : 16);
            }
        }
    }

    public static void onNeighborChange(TActiveDevice $this, Block b) {
        if (((InstancedBlockTile)$this).world().isBlockIndirectlyGettingPowered(((InstancedBlockTile)$this).x(), ((InstancedBlockTile)$this).y(), ((InstancedBlockTile)$this).z())) {
            if ($this.powered()) {
                return;
            }
            $this.powered_$eq(true);
            ((InstancedBlockTile)$this).markDirty();
            if ($this.active()) {
                return;
            }
            $this.active_$eq(true);
            $this.onActivate();
            $this.sendStateUpdate();
        } else {
            if ($this.active() && !((InstancedBlockTile)$this).isTickScheduled()) {
                ((InstancedBlockTile)$this).scheduleTick(4);
            }
            $this.powered_$eq(false);
            ((InstancedBlockTile)$this).markDirty();
        }
    }

    public static void onDeactivate(TActiveDevice $this) {
    }

    public static void exportBuffer(TActiveDevice $this) {
        do {
            PressurePayload pressurePayload;
            if ($this.storage().isEmpty()) {
                return;
            }
            PressurePayload r = $this.storage().peek();
            if ($this.exportPipe(r) || $this.exportInv(r) || $this.exportEject(r)) {
                pressurePayload = $this.storage().poll();
                continue;
            }
            $this.storage().backlogged_$eq(true);
            pressurePayload = BoxedUnit.UNIT;
        } while (!$this.storage().backlogged());
    }

    public static boolean exportPipe(TActiveDevice $this, PressurePayload r) {
        boolean bl;
        TPressureTube tPressureTube;
        TMultiPart tMultiPart = PRLib$.MODULE$.getMultiPart((IBlockAccess)((InstancedBlockTile)$this).world(), ((TTileOrient)$this).position().offset(((TTileOrient)$this).side()), 6);
        if (tMultiPart instanceof TPressureTube && (tPressureTube = (TPressureTube)tMultiPart).hasDestination(r, ((TTileOrient)$this).side() ^ 1)) {
            tPressureTube.injectPayload(r, ((TTileOrient)$this).side());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean exportInv(TActiveDevice $this, PressurePayload r) {
        boolean bl;
        IInventory inv = InvWrapper$.MODULE$.getInventory(((InstancedBlockTile)$this).world(), ((TTileOrient)$this).position().offset(((TTileOrient)$this).side()));
        if (inv == null) {
            bl = false;
        } else {
            InvWrapper w = InvWrapper$.MODULE$.wrap(inv).setSlotsFromSide(((TTileOrient)$this).side() ^ 1);
            ItemKeyStack itemKeyStack = r.payload();
            itemKeyStack.stackSize_$eq(itemKeyStack.stackSize() - w.injectItem(r.payload().makeStack(), true));
            bl = r.payload().stackSize() <= 0;
        }
        return bl;
    }

    public static boolean exportEject(TActiveDevice $this, PressurePayload r) {
        BlockCoord pos = ((TTileOrient)$this).position().offset(((TTileOrient)$this).side());
        if (((InstancedBlockTile)$this).world().blockExists(pos.x, pos.y, pos.z) && !((InstancedBlockTile)$this).world().isAirBlock(pos.x, pos.y, pos.z)) {
            return false;
        }
        WorldLib$.MODULE$.centerEject(((InstancedBlockTile)$this).world(), ((TTileOrient)$this).position(), r.payload().makeStack(), ((TTileOrient)$this).side(), 0.25);
        return true;
    }

    public static void onBlockRemoval(TActiveDevice $this) {
        $this.mrtjp$projectred$expansion$TActiveDevice$$super$onBlockRemoval();
        while (!$this.storage().isEmpty()) {
            WorldLib$.MODULE$.dropItem(((InstancedBlockTile)$this).world(), ((InstancedBlockTile)$this).x(), ((InstancedBlockTile)$this).y(), ((InstancedBlockTile)$this).z(), $this.storage().poll().payload().makeStack());
        }
        return;
    }

    public static void $init$(TActiveDevice $this) {
        $this.mrtjp$projectred$expansion$TActiveDevice$_setter_$storage_$eq(new ItemStorage());
        $this.powered_$eq(false);
        $this.active_$eq(false);
    }
}

