/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import mrtjp.core.block.InstancedBlockTile;
import mrtjp.core.block.TTileOrient;
import mrtjp.projectred.api.IScrewdriver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0003\u0003I!a\u0003+jY\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0013\u0015D\b/\u00198tS>t'BA\u0003\u0007\u0003)\u0001(o\u001c6fGR\u0014X\r\u001a\u0006\u0002\u000f\u0005)QN\u001d;ka\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0006E2|7m\u001b\u0006\u0003\u001f\u0019\tAaY8sK&\u0011\u0011\u0003\u0004\u0002\u0013\u0013:\u001cH/\u00198dK\u0012\u0014En\\2l)&dW\r\u0005\u0002\f'%\u0011A\u0003\u0004\u0002\f)RKG.Z(sS\u0016tG\u000fC\u0003\u0017\u0001\u0011\u0005q#\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0005!)1\u0004\u0001C!9\u0005iqN\u001c\"m_\u000e\\\u0007\u000b\\1dK\u0012$b!H\u0012)U]z\u0004C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001\n\u000eA\u0002\u0015\n\u0011a\u001d\t\u0003=\u0019J!aJ\u0010\u0003\u0007%sG\u000fC\u0003*5\u0001\u0007Q%\u0001\u0003nKR\f\u0007\"B\u0016\u001b\u0001\u0004a\u0013A\u00029mCf,'\u000f\u0005\u0002.k5\taF\u0003\u0002,_)\u0011\u0001'M\u0001\u0007K:$\u0018\u000e^=\u000b\u0005I\u001a\u0014!C7j]\u0016\u001c'/\u00194u\u0015\u0005!\u0014a\u00018fi&\u0011aG\f\u0002\r\u000b:$\u0018\u000e^=QY\u0006LXM\u001d\u0005\u0006qi\u0001\r!O\u0001\u0006gR\f7m\u001b\t\u0003uuj\u0011a\u000f\u0006\u0003yE\nA!\u001b;f[&\u0011ah\u000f\u0002\n\u0013R,Wn\u0015;bG.DQ\u0001\u0011\u000eA\u0002\u0005\u000b1\u0001[5u!\t\u0011\u0015*D\u0001D\u0015\t!U)A\u0002wK\u000eT!AR$\u0002\u00071L'MC\u0001I\u0003-\u0019w\u000eZ3dQ&\u001c7.\u001a8\n\u0005)\u001b%a\u0002,fGR|'o\r\u0005\u0006\u0019\u0002!\t!T\u0001\u000bG\u0006d7MR1dS:<GCA\u0013O\u0011\u0015y5\n1\u0001-\u0003\r)g\u000e\u001e\u0005\u0006#\u0002!\tEU\u0001\noJLG/\u001a#fg\u000e$\"!H*\t\u000bQ\u0003\u0006\u0019A+\u0002\u0007=,H\u000f\u0005\u0002W36\tqK\u0003\u0002Y\u000b\u0006!A-\u0019;b\u0013\tQvK\u0001\u0007N\u0007\u0012\u000bG/Y(viB,H\u000fC\u0003]\u0001\u0011\u0005S,\u0001\u0005sK\u0006$G)Z:d)\tib\fC\u0003`7\u0002\u0007\u0001-\u0001\u0002j]B\u0011a+Y\u0005\u0003E^\u00131\"T\"ECR\f\u0017J\u001c9vi\")A\r\u0001C!K\u0006!1/\u0019<f)\tib\rC\u0003hG\u0002\u0007\u0001.A\u0002uC\u001e\u0004\"!\u001b7\u000e\u0003)T!a[\u0019\u0002\u00079\u0014G/\u0003\u0002nU\nqaJ\u0011+UC\u001e\u001cu.\u001c9pk:$\u0007\"B8\u0001\t\u0003\u0002\u0018\u0001\u00027pC\u0012$\"!H9\t\u000b\u001dt\u0007\u0019\u00015\t\u000bM\u0004A\u0011\t;\u0002\tI,\u0017\r\u001a\u000b\u0004;U4\b\"B0s\u0001\u0004\u0001\u0007\"B<s\u0001\u0004)\u0013aA6fs\")\u0011\u0010\u0001C!u\u0006\u0001rN\u001c\"m_\u000e\\\u0017i\u0019;jm\u0006$X\r\u001a\u000b\u0004wz|\bC\u0001\u0010}\u0013\tixDA\u0004C_>dW-\u00198\t\u000b-B\b\u0019\u0001\u0017\t\r\u0005\u0005\u0001\u00101\u0001&\u0003\u001d\t7\r^:jI\u0016Dq!!\u0002\u0001\t\u0003\t9!A\tjgJ{G/\u0019;j_:\fE\u000e\\8xK\u0012$2a_A\u0005\u0011\u001d\tY!a\u0001A\u0002\u0015\n1A]8u\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\tQ\"[:TS\u0012,\u0017\t\u001c7po\u0016$GcA>\u0002\u0014!1A%!\u0004A\u0002\u0015Bq!a\u0006\u0001\t\u0003\tI\"\u0001\u0006e_\u0016\u001c(k\u001c;bi\u0016,\u0012a\u001f\u0005\b\u0003;\u0001A\u0011AA\r\u0003)!w.Z:Pe&,g\u000e\u001e\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003A\u0019XM\u001c3Pe&,g\u000e^+qI\u0006$X\rF\u0001\u001e\u0011\u001d\t9\u0003\u0001C\u0001\u0003G\tab\u001c8CY>\u001c7NU8uCR,G\r")
public abstract class TileMachine
extends InstancedBlockTile
implements TTileOrient {
    private byte orientation;

    public byte orientation() {
        return this.orientation;
    }

    public void orientation_$eq(byte x$1) {
        this.orientation = x$1;
    }

    public /* synthetic */ void mrtjp$core$block$TTileOrient$$super$save(NBTTagCompound tag) {
        super.save(tag);
    }

    public /* synthetic */ void mrtjp$core$block$TTileOrient$$super$load(NBTTagCompound tag) {
        super.load(tag);
    }

    public /* synthetic */ void mrtjp$core$block$TTileOrient$$super$readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public /* synthetic */ void mrtjp$core$block$TTileOrient$$super$writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public int side() {
        return TTileOrient.class.side((TTileOrient)this);
    }

    public void setSide(int s) {
        TTileOrient.class.setSide((TTileOrient)this, (int)s);
    }

    public int rotation() {
        return TTileOrient.class.rotation((TTileOrient)this);
    }

    public void setRotation(int r) {
        TTileOrient.class.setRotation((TTileOrient)this, (int)r);
    }

    public BlockCoord position() {
        return TTileOrient.class.position((TTileOrient)this);
    }

    public Transformation rotationT() {
        return TTileOrient.class.rotationT((TTileOrient)this);
    }

    public void onOrientChanged(int oldOrient) {
        TTileOrient.class.onOrientChanged((TTileOrient)this, (int)oldOrient);
    }

    public int toInternal(int absRot) {
        return TTileOrient.class.toInternal((TTileOrient)this, (int)absRot);
    }

    public int toAbsolute(int r) {
        return TTileOrient.class.toAbsolute((TTileOrient)this, (int)r);
    }

    public int absoluteDir(int absRot) {
        return TTileOrient.class.absoluteDir((TTileOrient)this, (int)absRot);
    }

    public int absoluteRot(int absDir) {
        return TTileOrient.class.absoluteRot((TTileOrient)this, (int)absDir);
    }

    public void onBlockPlaced(int s, int meta, EntityPlayer player, ItemStack stack, Vector3 hit) {
        this.setSide(this.doesOrient() ? this.calcFacing(player) : 0);
        this.setRotation(this.doesRotate() ? Rotation.getSidedRotation((EntityPlayer)player, (int)(this.side() ^ 1)) : 0);
    }

    public int calcFacing(EntityPlayer ent) {
        int n;
        int yawrx = (int)Math.floor((double)(ent.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (Math.abs(ent.posX - (double)this.x()) < 2.0 && Math.abs(ent.posZ - (double)this.z()) < 2.0) {
            double p = ent.posY + 1.82 - (double)ent.yOffset - (double)this.y();
            if (p > 2.0) {
                return 0;
            }
            if (p < 0.0) {
                return 1;
            }
        }
        int n2 = yawrx;
        switch (n2) {
            default: {
                n = 5;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 0: {
                n = 3;
            }
        }
        return n;
    }

    public void writeDesc(MCDataOutput out) {
        TTileOrient.class.writeDesc((TTileOrient)this, (MCDataOutput)out);
        out.writeByte((int)this.orientation());
    }

    public void readDesc(MCDataInput in) {
        TTileOrient.class.readDesc((TTileOrient)this, (MCDataInput)in);
        this.orientation_$eq(in.readByte());
    }

    public void save(NBTTagCompound tag) {
        tag.setByte("rot", this.orientation());
    }

    public void load(NBTTagCompound tag) {
        this.orientation_$eq(tag.getByte("rot"));
    }

    public void read(MCDataInput in, int key) {
        int n = key;
        switch (n) {
            default: {
                super.read(in, key);
                break;
            }
            case 1: {
                this.orientation_$eq(in.readByte());
                this.markRender();
            }
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int actside) {
        ItemStack held = player.getHeldItem();
        if (held != null && held.getItem() instanceof IScrewdriver) {
            if (this.world().isRemote) {
                return true;
            }
            if (!player.isSneaking() && this.doesOrient()) {
                this.orient$1(player, held);
            } else {
                this.rotate$1(player, held);
            }
            return true;
        }
        return false;
    }

    public boolean isRotationAllowed(int rot) {
        return true;
    }

    public boolean isSideAllowed(int s) {
        return true;
    }

    public boolean doesRotate() {
        return true;
    }

    public boolean doesOrient() {
        return false;
    }

    public void sendOrientUpdate() {
        this.streamToSend(this.writeStream(1).writeByte((int)this.orientation())).sendToChunk();
    }

    public void onBlockRotated() {
    }

    private final void rotate$1(EntityPlayer player$1, ItemStack held$1) {
        if (this.doesRotate()) {
            int old = this.rotation();
            do {
                this.setRotation((this.rotation() + 1) % 4);
            } while (old != this.rotation() && !this.isRotationAllowed(this.rotation()));
            if (old != this.rotation()) {
                this.sendOrientUpdate();
            }
            this.world().notifyBlocksOfNeighborChange(this.x(), this.y(), this.z(), this.getBlock());
            this.onBlockRotated();
            ((IScrewdriver)held$1.getItem()).damageScrewdriver(this.world(), player$1);
        }
    }

    private final void orient$1(EntityPlayer player$1, ItemStack held$1) {
        if (this.doesOrient()) {
            int old = this.side();
            do {
                this.setSide((this.side() + 1) % 6);
            } while (old != this.side() && !this.isSideAllowed(this.side()));
            if (old != this.side()) {
                this.sendOrientUpdate();
            }
            this.world().notifyBlocksOfNeighborChange(this.x(), this.y(), this.z(), this.getBlock());
            this.onBlockRotated();
            ((IScrewdriver)held$1.getItem()).damageScrewdriver(this.world(), player$1);
        }
    }

    public TileMachine() {
        TTileOrient.class.$init$((TTileOrient)this);
    }
}

