/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.Comparator;
import java.util.UUID;
import java.util.concurrent.PriorityBlockingQueue;
import mrtjp.core.inventory.InvWrapper;
import mrtjp.core.inventory.InvWrapper$;
import mrtjp.core.item.ItemKey;
import mrtjp.core.item.ItemKeyStack;
import mrtjp.core.item.ItemKeyStack$;
import mrtjp.core.util.Pair2;
import mrtjp.core.world.Messenger$;
import mrtjp.core.world.WorldLib$;
import mrtjp.projectred.api.ISpecialLinkState;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.TCenterAcquisitions;
import mrtjp.projectred.core.TCenterConnectable;
import mrtjp.projectred.core.TSwitchPacket;
import mrtjp.projectred.transportation.AbstractPipePayload;
import mrtjp.projectred.transportation.AbstractPipePayload$;
import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.ItemRouterUtility;
import mrtjp.projectred.transportation.LSPathFinder$;
import mrtjp.projectred.transportation.LogisticPathFinder;
import mrtjp.projectred.transportation.NetworkPayload;
import mrtjp.projectred.transportation.PayloadPipePart;
import mrtjp.projectred.transportation.PipeDefs$;
import mrtjp.projectred.transportation.Priorities;
import mrtjp.projectred.transportation.Priorities$;
import mrtjp.projectred.transportation.RouteFX;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.RouterServices$;
import mrtjp.projectred.transportation.StartEndPath;
import mrtjp.projectred.transportation.SyncResponse;
import mrtjp.projectred.transportation.TNetworkPipe;
import mrtjp.projectred.transportation.TNetworkPipe$;
import mrtjp.projectred.transportation.TNetworkPipe$TransitComparator$;
import mrtjp.projectred.transportation.TNetworkSubsystem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public abstract class TNetworkPipe$class {
    public static void save(TNetworkPipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$save(tag);
        tag.setString("rid", TNetworkPipe$class.getRouterId($this).toString());
        tag.setInteger("sent", $this.statsSent());
        tag.setInteger("rec", $this.statsReceived());
        tag.setInteger("relay", $this.statsRelayed());
    }

    public static void load(TNetworkPipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$load(tag);
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq(UUID.fromString(tag.getString("rid")));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            $this.statsSent_$eq(tag.getInteger("sent"));
            $this.statsReceived_$eq(tag.getInteger("rec"));
            $this.statsRelayed_$eq(tag.getInteger("relay"));
            return;
        }
    }

    public static void writeDesc(TNetworkPipe $this, MCDataOutput packet) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$writeDesc(packet);
        packet.writeByte((int)$this.linkMap());
        packet.writeLong(TNetworkPipe$class.getRouterId($this).getMostSignificantBits());
        packet.writeLong(TNetworkPipe$class.getRouterId($this).getLeastSignificantBits());
    }

    public static void readDesc(TNetworkPipe $this, MCDataInput packet) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$readDesc(packet);
        $this.linkMap_$eq(packet.readByte());
        long mostSigBits = packet.readLong();
        long leastSigBits = packet.readLong();
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq(new UUID(mostSigBits, leastSigBits));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UUID getRouterId(TNetworkPipe $this) {
        BoxedUnit boxedUnit;
        if ($this.routerId() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return $this.routerId();
        }
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq($this.router() == null ? UUID.randomUUID() : $this.router().getID());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit2;
            return $this.routerId();
        }
    }

    private static void removeFromTransitQueue(TNetworkPipe $this, NetworkPayload r) {
        $this.transitQueue().removeAll(JavaConversions$.MODULE$.asJavaCollection((Iterable)JavaConversions$.MODULE$.collectionAsScalaIterable($this.transitQueue()).filter((Function1)new Serializable($this, r){
            private final NetworkPayload r$1;

            public final boolean apply(Pair2<NetworkPayload, Object> p) {
                Object object = p.get1();
                NetworkPayload networkPayload = this.r$1;
                return !(object != null ? !object.equals(networkPayload) : networkPayload != null);
            }
            {
                this.r$1 = r$1;
            }
        })));
    }

    private static void tickTransitQueue(TNetworkPipe $this) {
        $this.transitQueue().removeAll(JavaConversions$.MODULE$.asJavaCollection((Iterable)JavaConversions$.MODULE$.collectionAsScalaIterable($this.transitQueue()).filterNot((Function1)new Serializable($this){

            public final boolean apply(Pair2<NetworkPayload, Object> p) {
                p.set2((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)p.get2()) - 1)));
                return BoxesRunTime.unboxToInt((Object)p.get2()) >= 0;
            }
        })));
    }

    public static int countInTransit(TNetworkPipe $this, ItemKey key) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConversions$.MODULE$.collectionAsScalaIterable($this.transitQueue()).filter((Function1)new Serializable($this, key){
            private final ItemKey key$1;

            public final boolean apply(Pair2<NetworkPayload, Object> p) {
                ItemKey itemKey = ((AbstractPipePayload)p.get1()).payload().key();
                ItemKey itemKey2 = this.key$1;
                return !(itemKey != null ? !itemKey.equals(itemKey2) : itemKey2 != null);
            }
            {
                this.key$1 = key$1;
            }
        })).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){

            public final int apply(int b, Pair2<NetworkPayload, Object> a) {
                return b + BoxesRunTime.unboxToInt((Object)a.get2());
            }
        }));
    }

    private static void dispatchQueuedPayload(TNetworkPipe $this, NetworkPayload r) {
        $this.injectPayload(r, r.input());
        Router dest = RouterServices$.MODULE$.getRouter(r.destinationIP());
        if (dest != null) {
            IWorldRouter wr = dest.getParent();
            wr.itemEnroute(r);
            RouteFX.spawnType1(RouteFX.color_sync, 8, new BlockCoord((TileEntity)((TMultiPart)wr.getContainer()).tile()), ((TMultiPart)$this).world());
        }
        RouteFX.spawnType1(RouteFX.color_send, 8, new BlockCoord((TileEntity)((TMultiPart)$this).tile()), ((TMultiPart)$this).world());
        $this.statsSent_$eq($this.statsSent() + 1);
    }

    public static void queueSwapSendItem(TNetworkPipe $this, NetworkPayload r) {
        $this.swapQueue_$eq((Vector<NetworkPayload>)((Vector)$this.swapQueue().$colon$plus((Object)r, Vector$.MODULE$.canBuildFrom())));
    }

    private static NetworkPayload pollFromSwapQueue(TNetworkPipe $this, ItemKeyStack stack) {
        Option option;
        block4: {
            NetworkPayload networkPayload;
            block3: {
                block2: {
                    option = $this.swapQueue().find((Function1)new TNetworkPipe$.anonfun.1($this, stack));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    NetworkPayload r = (NetworkPayload)some.x();
                    int idx = $this.swapQueue().indexOf((Object)r);
                    $this.swapQueue_$eq((Vector<NetworkPayload>)((Vector)$this.swapQueue().take(idx).$plus$plus((GenTraversableOnce)$this.swapQueue().drop(idx + 1), Vector$.MODULE$.canBuildFrom())));
                    networkPayload = r;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                networkPayload = null;
            }
            return networkPayload;
        }
        throw new MatchError((Object)option);
    }

    public static final void update(TNetworkPipe $this) {
        if ($this.needsWork()) {
            $this.needsWork_$eq(false);
            Object object = ((TMultiPart)$this).world().isRemote ? BoxedUnit.UNIT : $this.getRouter();
            return;
        }
        if (!((TMultiPart)$this).world().isRemote) {
            $this.getRouter().update(((TMultiPart)$this).world().getTotalWorldTime() % (long)Configurator.detectionFrequency == (long)$this.searchDelay());
        }
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$update();
        while ($this.sendQueue().nonEmpty()) {
            TNetworkPipe$class.dispatchQueuedPayload($this, TNetworkPipe$class.sendPoll$1($this));
        }
        TNetworkPipe$class.tickTransitQueue($this);
        if (((TMultiPart)$this).world().isRemote) {
            $this.updateClient();
        } else {
            $this.updateServer();
        }
    }

    public static void updateServer(TNetworkPipe $this) {
    }

    public static void updateClient(TNetworkPipe $this) {
        if (((TMultiPart)$this).world().getTotalWorldTime() % (long)(Configurator.detectionFrequency * 20) == (long)$this.searchDelay()) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this){
                private final /* synthetic */ TNetworkPipe $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if ((this.$outer.linkMap() & 1 << i) != 0) {
                        RouteFX.spawnType3(RouteFX.color_blink, 1, i, this.$outer.getCoords(), ((TMultiPart)this.$outer).world());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public static boolean refreshState(TNetworkPipe $this) {
        if (((TMultiPart)$this).world().isRemote) {
            return false;
        }
        IntRef link = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, link){
            private final /* synthetic */ TNetworkPipe $outer;
            private final IntRef link$1;

            public final void apply(int s) {
                this.apply$mcVI$sp(s);
            }

            public void apply$mcVI$sp(int s) {
                if (this.$outer.getRouter().LSAConnectionExists(s)) {
                    this.link$1.elem |= 1 << s;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.link$1 = link$1;
            }
        });
        if ($this.linkMap() != link.elem) {
            $this.linkMap_$eq((byte)link.elem);
            $this.sendLinkMapUpdate();
            return true;
        }
        return false;
    }

    public static TNetworkPipe getContainer(TNetworkPipe $this) {
        return $this;
    }

    public static void endReached(TNetworkPipe $this, NetworkPayload r) {
        if (!(((TMultiPart)$this).world().isRemote || ((TCenterConnectable)((Object)$this)).maskConnects(r.output()) && ((PayloadPipePart)((Object)$this)).passToNextPipe(r))) {
            IInventory inv;
            BlockCoord bc = new BlockCoord((TileEntity)((TMultiPart)$this).tile()).offset(r.output());
            TileEntity t = WorldLib$.MODULE$.getTileEntity((IBlockAccess)((TMultiPart)$this).world(), bc);
            ISpecialLinkState state = LSPathFinder$.MODULE$.getLinkState(t);
            if (state != null && t instanceof IInventory) {
                TMultiPart part;
                TileEntity dest = state.getLink(t);
                IInventory inv2 = (IInventory)t;
                if (dest instanceof TileMultipart && (part = ((TileMultipart)dest).partMap(6)) instanceof TNetworkPipe) {
                    TNetworkPipe pipe = (TNetworkPipe)part;
                    InvWrapper w = InvWrapper$.MODULE$.wrap(inv2).setSlotsFromSide(r.output() ^ 1);
                    int room = w.getSpaceForItem(r.payload().key());
                    if (room >= r.payload().stackSize()) {
                        w.injectItem(r.payload().makeStack(), true);
                        pipe.queueSwapSendItem(r);
                        return;
                    }
                    ((PayloadPipePart)((Object)$this)).bounceStack(r);
                    return;
                }
            }
            if ((inv = InvWrapper$.MODULE$.getInventory(((TMultiPart)$this).world(), bc)) != null) {
                InvWrapper w = InvWrapper$.MODULE$.wrap(inv).setSlotsFromSide(r.output() ^ 1);
                ItemKeyStack itemKeyStack = r.payload();
                itemKeyStack.stackSize_$eq(itemKeyStack.stackSize() - w.injectItem(r.payload().makeStack(), true));
            }
            if (r.payload().stackSize() > 0) {
                ((PayloadPipePart)((Object)$this)).bounceStack(r);
            }
        }
    }

    public static void read(TNetworkPipe $this, MCDataInput packet, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$transportation$TNetworkPipe$$super$read(packet, key);
                break;
            }
            case 5: {
                TNetworkPipe$class.handleLinkMap($this, packet);
            }
        }
    }

    public static void sendLinkMapUpdate(TNetworkPipe $this) {
        ((TSwitchPacket)((Object)$this)).getWriteStreamOf(5).writeByte((int)$this.linkMap());
    }

    private static void handleLinkMap(TNetworkPipe $this, MCDataInput packet) {
        byte old = $this.linkMap();
        $this.linkMap_$eq(packet.readByte());
        int high = ~old & $this.linkMap();
        int low = ~$this.linkMap() & old;
        BlockCoord bc = $this.getCoords();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, high, low, bc){
            private final /* synthetic */ TNetworkPipe $outer;
            private final int high$1;
            private final int low$1;
            private final BlockCoord bc$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if ((this.high$1 & 1 << i) != 0) {
                    RouteFX.spawnType3(RouteFX.color_linked, 1, i, this.bc$1, ((TMultiPart)this.$outer).world());
                }
                if ((this.low$1 & 1 << i) != 0) {
                    RouteFX.spawnType3(RouteFX.color_unlinked, 1, i, this.bc$1, ((TMultiPart)this.$outer).world());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.high$1 = high$1;
                this.low$1 = low$1;
                this.bc$1 = bc$1;
            }
        });
        ((TMultiPart)$this).tile().markRender();
    }

    public static void onRemoved(TNetworkPipe $this) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$onRemoved();
        TNetworkPipe$.MODULE$.delayDelta_$eq(Math.max(TNetworkPipe$.MODULE$.delayDelta() - 1, 0));
        Router r = $this.getRouter();
        if (r != null) {
            r.decommission();
        }
    }

    public static boolean activate(TNetworkPipe $this, EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if ($this.mrtjp$projectred$transportation$TNetworkPipe$$super$activate(player, hit, item)) {
            return true;
        }
        if (item != null && item.getItem() instanceof ItemRouterUtility) {
            if (!((TMultiPart)$this).world().isRemote) {
                String s = new StringBuilder().append((Object)"/#fR").append((Object)BoxesRunTime.boxToInteger((int)$this.getRouter().getIPAddress())).append((Object)" route statistics: ").append((Object)"\nreceived: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsReceived())).append((Object)"\nsent: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsSent())).append((Object)"\nrelayed: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsRelayed())).append((Object)"\n\nroute table size: ").append($this.getRouter().getRouteTable().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){

                    public final int apply(int b, Vector<StartEndPath> v) {
                        return v == null ? b : b + 1;
                    }
                })).toString();
                PacketCustom packet = Messenger$.MODULE$.createPacket();
                packet.writeDouble((double)((TMultiPart)$this).x() + 0.0);
                packet.writeDouble((double)((TMultiPart)$this).y() + 0.5);
                packet.writeDouble((double)((TMultiPart)$this).z() + 0.0);
                packet.writeString(s);
                packet.sendToPlayer(player);
            }
            return true;
        }
        return false;
    }

    public static IIcon getIcon(TNetworkPipe $this, int side) {
        IIcon[] array = PipeDefs$.MODULE$.ROUTEDJUNCTION().sprites();
        int ind = side == $this.inOutSide() ? 2 : 0;
        return ($this.linkMap() & 1 << side) != 0 ? array[1 + ind] : array[2 + ind];
    }

    public static void resolveDestination(TNetworkPipe $this, NetworkPayload r) {
        if ($this.needsWork()) {
            return;
        }
        IntRef color = IntRef.create((int)-1);
        r.output_$eq(6);
        r.refreshIP();
        if (r.destinationIP() <= 0 || r.destinationIP() > 0 && r.hasArrived()) {
            TNetworkPipe$class.reRoute$1($this, r, color);
        }
        r.refreshIP();
        if (r.destinationIP() > 0) {
            UUID uUID = r.destinationUUID();
            UUID uUID2 = $this.getRouter().getID();
            if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
                r.output_$eq($this.getDirForIncomingItem(r));
                if (r.output() == 6) {
                    TNetworkPipe$class.reRoute$1($this, r, color);
                } else {
                    color.elem = RouteFX.color_receive;
                    r.hasArrived_$eq(true);
                    $this.itemArrived(r);
                }
                r.travelLog_$eq(r.travelLog().$plus($this.getRouter().getIPAddress()));
            }
        }
        if (r.output() == 6) {
            r.output_$eq($this.getRouter().getDirection(r.destinationIP(), r.payload().key(), r.netPriority()));
            color.elem = RouteFX.color_relay;
        }
        if (r.output() == 6) {
            IntRef m = IntRef.create((int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, m){
                private final /* synthetic */ TNetworkPipe $outer;
                private final IntRef m$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if (((TCenterAcquisitions)((Object)this.$outer)).getStraight(i) instanceof TNetworkSubsystem) {
                        this.m$1.elem |= 1 << i;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                }
            });
            ((PayloadPipePart)((Object)$this)).chooseRandomDestination(r, ~m.elem);
            r.resetTrip();
            r.travelLog_$eq((BitSet)BitSet$.MODULE$.apply((Seq)Nil$.MODULE$));
            color.elem = RouteFX.color_routeLost;
        }
        if (color.elem == RouteFX.color_relay) {
            $this.statsRelayed_$eq($this.statsRelayed() + 1);
        }
        RouteFX.spawnType1(color.elem, 8, new BlockCoord((TileEntity)((TMultiPart)$this).tile()), ((TMultiPart)$this).world());
        $this.adjustSpeed(r);
    }

    public static void injectPayload(TNetworkPipe $this, NetworkPayload r, int in) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$injectPayload(r, in);
        Priorities.Priority priority = r.netPriority();
        Priorities.Priority priority2 = Priorities$.MODULE$.WANDERING();
        if (!(priority != null ? !((Object)priority).equals(priority2) : priority2 != null)) {
            r.tickPayloadWander();
        }
    }

    public static int getDirForIncomingItem(TNetworkPipe $this, NetworkPayload r) {
        return $this.inOutSide();
    }

    public static void adjustSpeed(TNetworkPipe $this, NetworkPayload r) {
        r.speed_$eq(r.netPriority().boost());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Router getRouter(TNetworkPipe $this) {
        BoxedUnit boxedUnit;
        if ($this.needsWork()) {
            return null;
        }
        if ($this.router() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return $this.router();
        }
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.router_$eq(RouterServices$.MODULE$.getOrCreateRouter(TNetworkPipe$class.getRouterId($this), $this));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit2;
            return $this.router();
        }
    }

    public static void itemEnroute(TNetworkPipe $this, NetworkPayload r) {
        $this.transitQueue().add((Pair2<NetworkPayload, Object>)new Pair2((Object)r, (Object)BoxesRunTime.boxToInteger((int)200)));
    }

    public static void itemArrived(TNetworkPipe $this, NetworkPayload r) {
        TNetworkPipe$class.removeFromTransitQueue($this, r);
        $this.trackedItemReceived(r.payload());
        $this.statsReceived_$eq($this.statsReceived() + 1);
    }

    public static SyncResponse getSyncResponse(TNetworkPipe $this, ItemKey item, SyncResponse rival) {
        return null;
    }

    public static void queueStackToSend(TNetworkPipe $this, ItemStack stack, int dirOfExtraction, Priorities.Priority priority, int destination) {
        Object object;
        ItemKeyStack stack2 = ItemKeyStack$.MODULE$.get(stack);
        NetworkPayload r = TNetworkPipe$class.pollFromSwapQueue($this, stack2);
        if (r == null) {
            r = new NetworkPayload(AbstractPipePayload$.MODULE$.claimID());
            r.payload_$eq(stack2);
            r.input_$eq(dirOfExtraction);
            object = r.setDestination(destination, priority);
        } else {
            object = BoxedUnit.UNIT;
        }
        $this.sendQueue_$eq((Vector<NetworkPayload>)((Vector)$this.sendQueue().$colon$plus((Object)r, Vector$.MODULE$.canBuildFrom())));
    }

    public static SyncResponse getLogisticPath(TNetworkPipe $this, ItemKey stack, BitSet exclusions, boolean excludeStart) {
        LogisticPathFinder p = new LogisticPathFinder($this.getRouter(), stack);
        Object object = exclusions == null ? BoxedUnit.UNIT : p.setExclusions(exclusions);
        p.setExcludeSource(excludeStart).findBestResult();
        return p.getResult();
    }

    public static TNetworkPipe getWorldRouter(TNetworkPipe $this) {
        return $this;
    }

    public static IWorldBroadcaster getBroadcaster(TNetworkPipe $this) {
        IWorldBroadcaster iWorldBroadcaster;
        TNetworkPipe tNetworkPipe = $this;
        if (tNetworkPipe instanceof IWorldBroadcaster) {
            TNetworkPipe tNetworkPipe2 = tNetworkPipe;
            iWorldBroadcaster = (IWorldBroadcaster)((Object)tNetworkPipe2);
        } else {
            iWorldBroadcaster = null;
        }
        return iWorldBroadcaster;
    }

    public static TNetworkPipe getRequester(TNetworkPipe $this) {
        return $this;
    }

    public static World getWorld(TNetworkPipe $this) {
        return ((TMultiPart)$this).world();
    }

    public static BlockCoord getCoords(TNetworkPipe $this) {
        return new BlockCoord((TileEntity)((TMultiPart)$this).tile());
    }

    public static void trackedItemLost(TNetworkPipe $this, ItemKeyStack s) {
    }

    public static void trackedItemReceived(TNetworkPipe $this, ItemKeyStack s) {
    }

    public static int getActiveFreeSpace(TNetworkPipe $this, ItemKey item) {
        IInventory real = $this.getInventory();
        return real == null ? 0 : InvWrapper$.MODULE$.wrap(real).setSlotsFromSide($this.getInterfacedSide()).getSpaceForItem(item);
    }

    /*
     * WARNING - void declaration
     */
    private static final NetworkPayload sendPoll$1(TNetworkPipe $this) {
        void var1_1;
        NetworkPayload first = (NetworkPayload)$this.sendQueue().head();
        $this.sendQueue_$eq((Vector<NetworkPayload>)$this.sendQueue().tail());
        return var1_1;
    }

    private static final void reRoute$1(TNetworkPipe $this, NetworkPayload r, IntRef color$1) {
        r.resetTrip();
        LogisticPathFinder f = new LogisticPathFinder($this.getRouter(), r.payload().key()).setExclusions(r.travelLog()).findBestResult();
        if (f.getResult() != null) {
            r.setDestination(f.getResult().responder(), f.getResult().priority());
            color$1.elem = RouteFX.color_route;
        }
    }

    public static void $init$(TNetworkPipe $this) {
        TNetworkPipe$.MODULE$.delayDelta_$eq(TNetworkPipe$.MODULE$.delayDelta() + 1);
        $this.searchDelay_$eq(TNetworkPipe$.MODULE$.delayDelta() % Configurator.detectionFrequency);
        $this.linkMap_$eq((byte)0);
        $this.router_$eq(null);
        $this.routerId_$eq(null);
        $this.mrtjp$projectred$transportation$TNetworkPipe$_setter_$routerIDLock_$eq(new Object());
        $this.needsWork_$eq(true);
        $this.sendQueue_$eq((Vector<NetworkPayload>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)));
        $this.transitQueue_$eq(new PriorityBlockingQueue<Pair2<NetworkPayload, Object>>(10, (Comparator<Pair2<NetworkPayload, Object>>)((Object)TNetworkPipe$TransitComparator$.MODULE$)));
        $this.swapQueue_$eq((Vector<NetworkPayload>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)));
        $this.statsReceived_$eq(0);
        $this.statsSent_$eq(0);
        $this.statsRelayed_$eq(0);
    }
}

