/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.multipart.TMultiPart;
import mrtjp.core.world.WorldLib$;
import mrtjp.projectred.core.TCenterAcquisitions;
import mrtjp.projectred.transportation.PayloadPipePart;
import mrtjp.projectred.transportation.PressurePathfinder;
import mrtjp.projectred.transportation.PressurePayload;
import mrtjp.projectred.transportation.PressurePriority$;
import mrtjp.projectred.transportation.SubcorePipePart;
import mrtjp.projectred.transportation.TPressureTube;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import scala.Predef$;

public abstract class TPressureTube$class {
    public static void save(TPressureTube $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TPressureTube$$super$save(tag);
        tag.setByte("flow", (byte)$this.lastFlow());
    }

    public static void load(TPressureTube $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TPressureTube$$super$load(tag);
        $this.lastFlow_$eq(tag.getByte("flow"));
    }

    public static int openOuts(TPressureTube $this) {
        return ((SubcorePipePart)((Object)$this)).clientConnMap();
    }

    public static void adjustSpeed(TPressureTube $this, PressurePayload r) {
        r.speed_$eq(0.05f);
    }

    public static int resolveOutputConflict(TPressureTube $this, int outs) {
        int out2 = outs & $this.openOuts() & 0x3F;
        if (Integer.bitCount(out2) == 1) {
            int dest = Integer.numberOfTrailingZeros(out2);
            $this.lastFlow_$eq(1 << (dest + 1) % 6);
            return dest;
        }
        if (Integer.bitCount(out2) > 1) {
            int strip = Integer.numberOfTrailingZeros($this.lastFlow());
            int dest = (Integer.numberOfTrailingZeros((out2 << 6 | out2) >> strip) + strip) % 6;
            $this.lastFlow_$eq(1 << (dest + 1) % 6);
            return dest;
        }
        return Integer.numberOfTrailingZeros($this.lastFlow());
    }

    public static boolean hasDestination(TPressureTube $this, PressurePayload r, int from) {
        int dim = ~(1 << from) & $this.openOuts();
        if (dim == 0) {
            return false;
        }
        PressurePathfinder pf = new PressurePathfinder(r.payload().key(), $this, dim, r.colour());
        pf.start();
        return pf.invDirs() != 0;
    }

    public static void resolveDestination(TPressureTube $this, PressurePayload r) {
        if (Integer.bitCount($this.openOuts()) > 2 || r.travelData() == 0) {
            int dim = ~(1 << (r.input() ^ 1)) & $this.openOuts();
            PressurePathfinder pf = new PressurePathfinder(r.payload().key(), $this, dim, r.colour());
            pf.start();
            if (pf.invDirs() != 0) {
                r.output_$eq($this.resolveOutputConflict(pf.invDirs()));
                r.travelData_$eq(PressurePriority$.MODULE$.inventory());
            } else if (pf.backlogDirs() != 0) {
                r.output_$eq($this.resolveOutputConflict(pf.backlogDirs()));
                r.travelData_$eq(PressurePriority$.MODULE$.backlog());
            } else {
                ((PayloadPipePart)((Object)$this)).chooseRandomDestination(r);
            }
        } else {
            ((PayloadPipePart)((Object)$this)).chooseRandomDestination(r);
        }
    }

    public static void injectPayload(TPressureTube $this, PressurePayload r, int in) {
        $this.mrtjp$projectred$transportation$TPressureTube$$super$injectPayload(r, in);
        if (r.travelData() == 0) {
            r.tickPayloadWander();
        }
    }

    public static boolean discoverStraightOverride(TPressureTube $this, int s) {
        boolean bl;
        if ($this.mrtjp$projectred$transportation$TPressureTube$$super$discoverStraightOverride(s)) {
            return true;
        }
        TileEntity tileEntity = WorldLib$.MODULE$.getTileEntity((IBlockAccess)((TMultiPart)$this).world(), ((TCenterAcquisitions)((Object)$this)).posOfStraight(s));
        if (tileEntity instanceof ISidedInventory) {
            TileEntity tileEntity2 = tileEntity;
            bl = Predef$.MODULE$.intArrayOps(((ISidedInventory)tileEntity2).getAccessibleSlotsFromSide(s ^ 1)).nonEmpty();
        } else {
            bl = tileEntity instanceof IInventory;
        }
        return bl;
    }

    public static boolean colorExclude(TPressureTube $this) {
        return $this.colour() == -1;
    }

    public static int filteredColors(TPressureTube $this) {
        return 1 << $this.colour();
    }

    public static void $init$(TPressureTube $this) {
        $this.lastFlow_$eq(0);
    }
}

