/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessOreNBTRecipe
extends ShapelessOreRecipe {
    public boolean keepNBT = false;
    public boolean checkNBT = false;
    public ItemStack output;

    public ShapelessOreNBTRecipe(Block result2, Object ... recipe) {
        this(new ItemStack(result2), recipe);
    }

    public ShapelessOreNBTRecipe(Item result2, Object ... recipe) {
        this(new ItemStack(result2), recipe);
    }

    public ShapelessOreNBTRecipe(ItemStack result2, Object ... recipe) {
        super(result2, recipe);
        this.output = result2.copy();
    }

    public ShapelessOreNBTRecipe setKeepNBT() {
        this.keepNBT = true;
        return this;
    }

    public ShapelessOreNBTRecipe setCheckNBT() {
        this.checkNBT = true;
        return this;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack out = this.output.copy();
        if (this.keepNBT) {
            ItemStack oldItemWithNBT = null;
            for (int i = 0; i < 9; ++i) {
                ItemStack slot = inv.getStackInSlot(i);
                if (slot == null || !slot.hasTagCompound()) continue;
                oldItemWithNBT = slot;
                break;
            }
            if (oldItemWithNBT != null) {
                out.setTagCompound(oldItemWithNBT.getTagCompound());
            }
        }
        return out;
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (target.getItem() == input.getItem() && (target.getItemDamage() == Short.MAX_VALUE || target.getItemDamage() == input.getItemDamage())) {
            if (this.checkNBT) {
                return target.getTagCompound().equals((Object)input.getTagCompound());
            }
            return true;
        }
        return false;
    }
}

