/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.util.MathHelper;

public class ParticleLogicApproachPoint
extends ParticleLogic {
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double approachSpeed;
    protected double targetDistance;
    protected boolean ignoreY;

    public ParticleLogicApproachPoint(Vector3 point, double approachSpeed, double targetDistance) {
        this.targetX = point.x;
        this.targetY = point.y;
        this.targetZ = point.z;
        this.approachSpeed = approachSpeed;
        this.targetDistance = targetDistance;
    }

    private double getDistanceSqToPoint(double x, double y, double z) {
        double var2 = this.particle.posX - x;
        double var4 = this.particle.posY - y;
        double var6 = this.particle.posZ - z;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public ParticleLogicApproachPoint setIgnoreY(boolean ignore) {
        this.ignoreY = ignore;
        return this;
    }

    @Override
    public void doUpdate() {
        double posX = this.particle.posX;
        double posZ = this.particle.posZ;
        double posY = this.particle.posY;
        double distanceToTarget = this.getDistanceSqToPoint(this.targetX, this.targetY, this.targetZ);
        double deltaZ = this.targetZ - this.particle.posZ;
        double deltaX = this.targetX - this.particle.posX;
        if (Math.abs(deltaX) > this.targetDistance || Math.abs(deltaZ) > this.targetDistance) {
            double angle;
            double radians = angle = Math.atan2(deltaZ, deltaX);
            posX = this.particle.posX + this.approachSpeed * Math.cos(radians);
            posZ = this.particle.posZ + this.approachSpeed * Math.sin(radians);
        }
        if (!this.ignoreY) {
            double deltaY = posY - this.targetY;
            double horizontalDistance = MathHelper.sqrt_double((double)(deltaX * deltaX + deltaZ * deltaZ));
            float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
            double pitchRadians = pitchRotation;
            posY = this.particle.posY + this.approachSpeed * Math.sin(pitchRadians);
        }
        if (distanceToTarget <= this.targetDistance * this.targetDistance) {
            this.onDestinationReached();
        } else {
            this.particle.setPosition(posX, posY, posZ);
        }
    }

    public void onDestinationReached() {
        this.finishLogic();
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicApproachPoint(new Vector3(this.targetX, this.targetY, this.targetZ), this.approachSpeed, this.targetDistance).setIgnoreY(this.ignoreY).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

