/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.MathHelper;

public class ParticleLogicFleeEntity
extends ParticleLogic {
    private Entity target;
    private double fleeSpeed;
    private double targetDistance;

    public ParticleLogicFleeEntity(Entity fleeEntity, double fleeSpeed, double targetDistance) {
        this.target = fleeEntity;
        this.fleeSpeed = fleeSpeed;
        this.targetDistance = targetDistance;
    }

    @Override
    public void doUpdate() {
        double deltaY;
        double angle;
        double distanceToTarget = this.particle.getDistanceToEntity(this.target);
        double deltaZ = this.particle.posZ - this.target.posZ;
        double deltaX = this.particle.posX - this.target.posX;
        double radians = angle = Math.atan2(deltaZ, deltaX);
        double posX = this.particle.posX + this.fleeSpeed * Math.cos(radians);
        double posY = this.particle.posY;
        double posZ = this.particle.posZ + this.fleeSpeed * Math.sin(radians);
        if (this.target instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)this.target;
            deltaY = posY - (entityliving.posY + (double)entityliving.getEyeHeight());
        } else {
            deltaY = (this.target.boundingBox.minY + this.target.boundingBox.maxY) / 2.0 - posY;
        }
        double horizontalDistance = MathHelper.sqrt_double((double)(deltaX * deltaX + deltaZ * deltaZ));
        float pitchRotation = (float)(-Math.atan2(deltaY, horizontalDistance));
        double pitchRadians = pitchRotation;
        posY = this.particle.posY + this.fleeSpeed * Math.sin(pitchRadians);
        if (distanceToTarget > this.targetDistance) {
            this.finishLogic();
        } else {
            this.particle.setPosition(posX, posY, posZ);
        }
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicFleeEntity(this.target, this.fleeSpeed, this.targetDistance).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

