/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.render.TextureUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import mrtjp.projectred.core.libmc.fx.CoreParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ParticleManagement {
    public static String name = "pr-fx";
    private final ArrayList<CoreParticle> particles = new ArrayList();
    private final ArrayList<CoreParticle> particleQueue = new ArrayList();
    public static final ParticleManagement instance = new ParticleManagement();

    public CoreParticle spawn(World world, String name, double x, double y, double z) {
        if (!world.isRemote) {
            return null;
        }
        if (Minecraft.getMinecraft().gameSettings.particleSetting == 2) {
            return null;
        }
        CoreParticle particle = new CoreParticle(world, x, y, z);
        particle.setTextureByName(name);
        this.addEffect(particle);
        return particle;
    }

    public void addEffect(CoreParticle effect) {
        this.particleQueue.add(effect);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.partialTicks);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.particles.clear();
        this.particleQueue.clear();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.updateParticles();
        }
    }

    private void updateParticles() {
        Minecraft.getMinecraft().mcProfiler.startSection(name + "-update");
        this.particles.addAll(this.particleQueue);
        this.particleQueue.clear();
        Iterator<CoreParticle> it = this.particles.iterator();
        while (it.hasNext()) {
            EntityFX particle = it.next();
            particle.onUpdate();
            if (!particle.isDead) continue;
            it.remove();
        }
        Minecraft.getMinecraft().mcProfiler.endSection();
    }

    private void render(float partialTicks) {
        Minecraft.getMinecraft().mcProfiler.startSection(name + "-render");
        EntityLivingBase player = Minecraft.getMinecraft().renderViewEntity;
        EntityFX.interpPosX = player.lastTickPosX + (player.posX - player.lastTickPosX) * (double)partialTicks;
        EntityFX.interpPosY = player.lastTickPosY + (player.posY - player.lastTickPosY) * (double)partialTicks;
        EntityFX.interpPosZ = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * (double)partialTicks;
        TextureUtils.bindAtlas((int)1);
        this.renderStandardParticles(partialTicks);
        Minecraft.getMinecraft().mcProfiler.endSection();
    }

    private void renderStandardParticles(float partialTicks) {
        float rotationX = ActiveRenderInfo.rotationX;
        float rotationZ = ActiveRenderInfo.rotationZ;
        float rotationYZ = ActiveRenderInfo.rotationYZ;
        float rotationXY = ActiveRenderInfo.rotationXY;
        float rotationXZ = ActiveRenderInfo.rotationXZ;
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)32826);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (CoreParticle particle : this.particles) {
            tessellator.setBrightness(particle.getBrightnessForRender(partialTicks));
            particle.renderParticle(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.draw();
        GL11.glPopAttrib();
    }
}

