/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.handler.MultipartSaveLoad$;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.fabrication.CircuitGui;
import mrtjp.projectred.fabrication.GateICPart;
import mrtjp.projectred.fabrication.ICTimerGateGui;
import mrtjp.projectred.fabrication.SequentialGateICPart;
import mrtjp.projectred.fabrication.SequentialICGateLogic;
import mrtjp.projectred.fabrication.TTimerGateLogic;
import net.minecraft.nbt.NBTTagCompound;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class TTimerGateLogic$class {
    public static void save(TTimerGateLogic $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$save(tag);
        tag.setInteger("pmax", $this.pointer_max());
        tag.setLong("pelapsed", $this.pointer_start() < 0L ? $this.pointer_start() : $this.getTotalTime() - $this.pointer_start());
        tag.setLong("tsave", $this.getTotalTime());
    }

    public static void load(TTimerGateLogic $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$load(tag);
        $this.pointer_max_$eq(tag.getInteger("pmax"));
        $this.pointer_start_$eq(tag.getLong("pelapsed"));
        $this.saveTime_$eq(tag.getLong("tsave"));
        if ($this.pointer_start() >= 0L) {
            $this.pointer_start_$eq($this.getTotalTime() - $this.pointer_start());
        }
    }

    public static void writeDesc(TTimerGateLogic $this, MCDataOutput packet) {
        $this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$writeDesc(packet);
        packet.writeInt($this.pointer_max());
        packet.writeLong($this.pointer_start());
    }

    public static void readDesc(TTimerGateLogic $this, MCDataInput packet) {
        $this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$readDesc(packet);
        $this.pointer_max_$eq(packet.readInt());
        $this.pointer_start_$eq(packet.readLong());
    }

    public static void read(TTimerGateLogic $this, MCDataInput packet, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$read(packet, key);
                break;
            }
            case 13: {
                $this.pointer_start_$eq(packet.readInt());
                if ($this.pointer_start() < 0L) break;
                $this.pointer_start_$eq($this.getTotalTime() - $this.pointer_start());
                break;
            }
            case 12: {
                $this.pointer_max_$eq(packet.readInt());
            }
        }
    }

    public static long getTotalTime(TTimerGateLogic $this) {
        return ((SequentialICGateLogic)((Object)$this)).gate().world().network() == null ? $this.saveTime() : (((SequentialICGateLogic)((Object)$this)).gate().world().network().getWorld() == null ? MultipartSaveLoad$.MODULE$.loadingWorld().getTotalWorldTime() : ((SequentialICGateLogic)((Object)$this)).gate().world().network().getWorld().getTotalWorldTime());
    }

    public static int pointerValue(TTimerGateLogic $this) {
        return $this.pointer_start() < 0L ? 0 : (int)($this.getTotalTime() - $this.pointer_start());
    }

    public static void sendPointerMaxUpdate(TTimerGateLogic $this) {
        ((SequentialICGateLogic)((Object)$this)).gate().writeStreamOf(12).writeInt($this.pointer_max());
    }

    public static void sendPointerUpdate(TTimerGateLogic $this) {
        ((SequentialICGateLogic)((Object)$this)).gate().writeStreamOf(13).writeInt($this.pointer_start() < 0L ? -1 : $this.pointerValue());
    }

    public static int getTimerMax(TTimerGateLogic $this) {
        return $this.pointer_max() + 2;
    }

    public static void setTimerMax(TTimerGateLogic $this, GateICPart gate, int time) {
        int t = time;
        int minTime = package$.MODULE$.max(4, Configurator.minTimerTicks);
        if (t < minTime) {
            t = minTime;
        }
        if (t != $this.pointer_max()) {
            $this.pointer_max_$eq(t - 2);
            $this.sendPointerMaxUpdate();
        }
    }

    public static void onTick(TTimerGateLogic $this, SequentialGateICPart gate) {
        if ($this.pointer_start() >= 0L) {
            if ($this.getTotalTime() >= $this.pointer_start() + (long)$this.pointer_max()) {
                $this.pointerTick();
            } else if ($this.pointer_start() > $this.getTotalTime()) {
                $this.pointer_start_$eq($this.getTotalTime());
            }
        }
    }

    public static void resetPointer(TTimerGateLogic $this) {
        if ($this.pointer_start() >= 0L) {
            $this.pointer_start_$eq(-1L);
            ((SequentialICGateLogic)((Object)$this)).gate().world().network().markSave();
            if (!((SequentialICGateLogic)((Object)$this)).gate().world().network().isRemote()) {
                $this.sendPointerUpdate();
            }
        }
    }

    public static void startPointer(TTimerGateLogic $this) {
        if ($this.pointer_start() < 0L) {
            $this.pointer_start_$eq($this.getTotalTime());
            ((SequentialICGateLogic)((Object)$this)).gate().world().network().markSave();
            if (!((SequentialICGateLogic)((Object)$this)).gate().world().network().isRemote()) {
                $this.sendPointerUpdate();
            }
        }
    }

    public static float interpPointer(TTimerGateLogic $this, float f) {
        return $this.pointer_start() < 0L ? 0.0f : ((float)$this.pointerValue() + f) / (float)$this.pointer_max();
    }

    @SideOnly(value=Side.CLIENT)
    public static CircuitGui createGui(TTimerGateLogic $this, SequentialGateICPart gate) {
        return new ICTimerGateGui(gate);
    }

    @SideOnly(value=Side.CLIENT)
    public static Seq getRolloverData(TTimerGateLogic $this, SequentialGateICPart gate, int detailLevel) {
        Builder data = Seq$.MODULE$.newBuilder();
        Object object = detailLevel > 1 ? data.$plus$eq((Object)new StringBuilder().append((Object)"interval: ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%.2f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)$this.getTimerMax() * 0.05))}))).append((Object)"s").toString()) : BoxedUnit.UNIT;
        return (Seq)$this.mrtjp$projectred$fabrication$TTimerGateLogic$$super$getRolloverData(gate, detailLevel).$plus$plus((GenTraversableOnce)data.result(), Seq$.MODULE$.canBuildFrom());
    }

    public static void $init$(TTimerGateLogic $this) {
        $this.pointer_max_$eq(38);
        $this.pointer_start_$eq(-1L);
        $this.saveTime_$eq(-1L);
    }
}

