/*
 * Decompiled with CFR 0.152.
 */
package com.iConomy.system;

import com.iConomy.iConomy;
import com.iConomy.system.BankAccount;
import com.iConomy.util.Constants;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bank {
    private int id = 0;
    private String name = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bank(String name) {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        int id = 0;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT id FROM " + Constants.SQLTable + "_Banks WHERE name = ? LIMIT 1");
            ps.setString(1, name);
            rs = ps.executeQuery();
            if (rs.next()) {
                id = rs.getInt("id");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        this.id = id;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bank(int id) {
        this.id = id;
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT name FROM " + Constants.SQLTable + "_Banks WHERE id = ? LIMIT 1");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                this.name = rs.getString("name");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMinor() {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        List<String> minor = Constants.Minor;
        String asString = Constants.Minor.get(0) + "," + Constants.Minor.get(1);
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT minor FROM " + Constants.SQLTable + "_Banks WHERE id = ? LIMIT 1");
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            if (rs.next()) {
                asString = rs.getString("minor");
                String[] denoms = asString.split(",");
                minor.set(0, denoms[0]);
                minor.set(1, denoms[1]);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return minor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMajor() {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        List<String> major = Constants.Major;
        String asString = Constants.Major.get(0) + "," + Constants.Major.get(1);
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT major FROM " + Constants.SQLTable + "_Banks WHERE id = ? LIMIT 1");
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            if (rs.next()) {
                asString = rs.getString("major");
                String[] denoms = asString.split(",");
                major.set(0, denoms[0]);
                major.set(1, denoms[1]);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return major;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getInitialHoldings() {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        double initial = Constants.BankHoldings;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT initial FROM " + Constants.SQLTable + "_Banks WHERE id = ? LIMIT 1");
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            if (rs.next()) {
                initial = rs.getDouble("initial");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFee() {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        double fee = Constants.BankFee;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT fee FROM " + Constants.SQLTable + "_Banks WHERE id = ? LIMIT 1");
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            if (rs.next()) {
                fee = rs.getDouble("fee");
            }
        }
        catch (Exception e) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return fee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Connection conn = null;
        Object rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("UPDATE " + Constants.SQLTable + "_Banks SET name = ? WHERE id = ?");
            ps.setString(1, name);
            ps.setInt(2, this.id);
            ps.executeUpdate();
            this.name = name;
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to update bank name: ");
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMajor(String singular, String plural) {
        Connection conn = null;
        Object rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("UPDATE " + Constants.SQLTable + "_Banks SET major = ? WHERE id = ?");
            ps.setString(1, singular + "," + plural);
            ps.setInt(2, this.id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to update bank major: ");
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinor(String singular, String plural) {
        Connection conn = null;
        Object rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("UPDATE " + Constants.SQLTable + "_Banks SET minor = ? WHERE id = ?");
            ps.setString(1, singular + "," + plural);
            ps.setInt(2, this.id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to update bank minor: ");
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialHoldings(double amount) {
        Connection conn = null;
        Object rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("UPDATE " + Constants.SQLTable + "_Banks SET initial = ? WHERE id = ?");
            ps.setDouble(1, amount);
            ps.setInt(2, this.id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to update bank initial amount: ");
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFee(double amount) {
        Connection conn = null;
        Object rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("UPDATE " + Constants.SQLTable + "_Banks SET fee = ? WHERE id = ?");
            ps.setDouble(1, amount);
            ps.setInt(2, this.id);
            ps.executeUpdate();
        }
        catch (Exception e) {
            System.out.println("[iConomy] Failed to update bank fee: ");
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccount(String account) {
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        boolean exists = false;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + Constants.SQLTable + "_BankRelations WHERE account_name = ? AND bank_id = ? LIMIT 1");
            ps.setString(1, account);
            ps.setInt(2, this.id);
            rs = ps.executeQuery();
            exists = rs.next();
        }
        catch (Exception e) {
            exists = false;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {}
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Double> getAccounts() {
        HashMap<String, Double> accounts = new HashMap<String, Double>();
        Connection conn = null;
        ResultSet rs = null;
        Statement ps = null;
        try {
            conn = iConomy.getiCoDatabase().getConnection();
            ps = conn.prepareStatement("SELECT * FROM " + Constants.SQLTable + "_BankRelations WHERE id = ? ORDER BY balance DESC");
            ps.setInt(1, this.id);
            rs = ps.executeQuery();
            while (rs.next()) {
                accounts.put(rs.getString("username"), rs.getDouble("balance"));
            }
        }
        catch (Exception e) {
            HashMap<String, Double> hashMap = accounts;
            return hashMap;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {}
            }
            iConomy.getiCoDatabase().close(conn);
        }
        return accounts;
    }

    public BankAccount getAccount(String account) {
        if (this.hasAccount(account)) {
            return new BankAccount(this.name, this.id, account);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAccount(String account) {
        if (!this.hasAccount(account)) {
            Connection conn = null;
            Object rs = null;
            Statement ps = null;
            try {
                conn = iConomy.getiCoDatabase().getConnection();
                ps = conn.prepareStatement("INSERT INTO " + Constants.SQLTable + "_BankRelations(account_name, bank_id, holdings) VALUES (?, ?, ?)");
                ps.setString(1, account);
                ps.setInt(2, this.id);
                ps.setDouble(3, this.getInitialHoldings());
                ps.executeUpdate();
            }
            catch (Exception e) {
                System.out.println("[iConomy] Error inserting bank account: " + e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ex) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {}
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createAccount(String account, double holdings) {
        if (!this.hasAccount(account)) {
            Connection conn = null;
            Object rs = null;
            Statement ps = null;
            try {
                conn = iConomy.getiCoDatabase().getConnection();
                ps = conn.prepareStatement("INSERT INTO " + Constants.SQLTable + "_BankRelations(account_name, bank_id, holdings) VALUES (?, ?, ?)");
                ps.setString(1, account);
                ps.setInt(2, this.id);
                ps.setDouble(3, holdings);
                ps.executeUpdate();
            }
            catch (Exception e) {
                System.out.println("[iConomy] Error inserting bank account: " + e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ex) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {}
                }
            }
            return true;
        }
        return false;
    }

    public void removeAccount(String account) {
        if (this.hasAccount(account)) {
            new BankAccount(this.name, this.id, account).remove();
        }
    }
}

