/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.actions;

import minetweaker.IUndoableAction;
import net.minecraft.item.ItemStack;

public class SetStackSizeAction
implements IUndoableAction {
    private final ItemStack stack;
    private final int size;
    private final int oldSize;

    public SetStackSizeAction(ItemStack stack, int size) {
        this.stack = stack;
        this.size = size;
        this.oldSize = stack.getMaxStackSize();
    }

    @Override
    public void apply() {
        SetStackSizeAction.set(this.stack, this.size);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        SetStackSizeAction.set(this.stack, this.oldSize);
    }

    @Override
    public String describe() {
        return "Setting max stack size of  " + this.stack.getDisplayName() + " to " + this.size;
    }

    @Override
    public String describeUndo() {
        return "Reverting max stack size of " + this.stack.getDisplayName() + " to " + this.oldSize;
    }

    private static void set(ItemStack stack, int size) {
        stack.getItem().setMaxStackSize(size);
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

