/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.brackets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minetweaker.IBracketHandler;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.BracketHandler;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler(priority=100)
public class ItemBracketHandler
implements IBracketHandler {
    private static final Map<String, Item> itemNames = new HashMap<String, Item>();
    private final IZenSymbol symbolAny = MineTweakerAPI.getJavaStaticFieldSymbol(IngredientAny.class, "INSTANCE");
    private final IJavaMethod method = MineTweakerAPI.getJavaMethod(ItemBracketHandler.class, "getItem", String.class, Integer.TYPE);

    public static void rebuildItemRegistry() {
        itemNames.clear();
        for (String itemName : Item.itemRegistry.getKeys()) {
            itemNames.put(itemName.replace(" ", ""), (Item)Item.itemRegistry.getObject(itemName));
        }
    }

    public static IItemStack getItem(String name, int meta) {
        Item item = itemNames.get(name);
        if (item != null) {
            return MineTweakerMC.getIItemStackWildcardSize(item, meta);
        }
        return null;
    }

    @Override
    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() == 1 && tokens.get(0).getValue().equals("*")) {
            return this.symbolAny;
        }
        int fromIndex = 0;
        int toIndex = tokens.size();
        int meta = 0;
        if (tokens.size() > 2) {
            if (tokens.get(0).getValue().equals("item") && tokens.get(1).getValue().equals(":")) {
                fromIndex = 2;
            }
            if (tokens.get(tokens.size() - 1).getType() == 2 && tokens.get(tokens.size() - 2).getValue().equals(":")) {
                toIndex = tokens.size() - 2;
                meta = Integer.parseInt(tokens.get(tokens.size() - 1).getValue());
            } else if (tokens.get(tokens.size() - 1).getValue().equals("*") && tokens.get(tokens.size() - 2).getValue().equals(":")) {
                toIndex = tokens.size() - 2;
                meta = Short.MAX_VALUE;
            }
        }
        return this.find(environment, tokens, fromIndex, toIndex, meta);
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex, int meta) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        String itemName = valueBuilder.toString();
        if (itemNames.containsKey(itemName)) {
            return new ItemReferenceSymbol(environment, itemName, meta);
        }
        return null;
    }

    private class ItemReferenceSymbol
    implements IZenSymbol {
        private final IEnvironmentGlobal environment;
        private final String name;
        private final int meta;

        public ItemReferenceSymbol(IEnvironmentGlobal environment, String name, int meta) {
            this.environment = environment;
            this.name = name;
            this.meta = meta;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionCallStatic(position, this.environment, ItemBracketHandler.this.method, new ExpressionString(position, this.name), new ExpressionInt(position, this.meta, ZenType.INT));
        }
    }
}

