/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.data;

import java.util.Map;
import minetweaker.api.data.IData;
import minetweaker.api.data.IDataConverter;
import minetweaker.mc1710.data.NBTConverter;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTUpdater
extends NBTConverter
implements IDataConverter<NBTBase> {
    private final NBTTagCompound nbt;

    public NBTUpdater(NBTTagCompound compound) {
        this.nbt = compound;
    }

    @Override
    public NBTBase fromMap(Map<String, IData> map) {
        for (Map.Entry<String, IData> entry : map.entrySet()) {
            if (this.nbt.hasKey(entry.getKey())) {
                if (entry.getValue() == null) {
                    this.nbt.removeTag(entry.getKey());
                    continue;
                }
                if (this.nbt.getTag(entry.getKey()).getId() == 10) {
                    NBTTagCompound tag = (NBTTagCompound)this.nbt.getTag(entry.getKey());
                    this.nbt.setTag(entry.getKey(), entry.getValue().convert(new NBTUpdater(this.nbt)));
                    continue;
                }
                this.nbt.setTag(entry.getKey(), NBTConverter.from(entry.getValue()));
                continue;
            }
            if (entry.getValue() == null) continue;
            this.nbt.setTag(entry.getKey(), NBTUpdater.from(entry.getValue()));
        }
        return this.nbt;
    }
}

