/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.recipes;

import java.util.List;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.mc1710.player.MCPlayer;
import minetweaker.mc1710.util.MineTweakerHacks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;

public class MCCraftingInventory
implements ICraftingInventory {
    private static final ThreadLocal<MCCraftingInventory> cache = new ThreadLocal();
    private static final ThreadLocal<MCCraftingInventory> cache2 = new ThreadLocal();
    private int width;
    private int height;
    private final IInventory inventory;
    private IItemStack[] stacks;
    private ItemStack[] original;
    private int stackCount;
    private final IPlayer player;
    private final EntityPlayer playerOrig;

    public static MCCraftingInventory get(InventoryCrafting inventory) {
        if (cache.get() == null || MCCraftingInventory.cache.get().inventory != inventory) {
            MCCraftingInventory result = new MCCraftingInventory(inventory);
            cache.set(result);
            return result;
        }
        MCCraftingInventory result = cache.get();
        result.update();
        return result;
    }

    public static MCCraftingInventory get(IInventory inventory, EntityPlayer player) {
        if (cache2.get() == null || MCCraftingInventory.cache2.get().inventory != inventory || MCCraftingInventory.cache2.get().player != player) {
            MCCraftingInventory result = new MCCraftingInventory(inventory, player);
            cache2.set(result);
            return result;
        }
        MCCraftingInventory result = cache2.get();
        result.update();
        return result;
    }

    private MCCraftingInventory(InventoryCrafting inventory) {
        this.inventory = inventory;
        this.width = this.height = (int)Math.sqrt(inventory.getSizeInventory());
        this.stacks = new IItemStack[this.width * this.height];
        this.original = new ItemStack[this.stacks.length];
        this.stackCount = 0;
        this.update();
        Container container = MineTweakerHacks.getCraftingContainer(inventory);
        if (container != null) {
            List slots = container.inventorySlots;
            if (!slots.isEmpty() && slots.get(0) instanceof SlotCrafting) {
                SlotCrafting slotCrafting = (SlotCrafting)slots.get(0);
                this.playerOrig = MineTweakerHacks.getCraftingSlotPlayer(slotCrafting);
                this.player = MineTweakerMC.getIPlayer(this.playerOrig);
            } else {
                this.playerOrig = null;
                this.player = null;
            }
        } else {
            this.playerOrig = null;
            this.player = null;
        }
    }

    public MCCraftingInventory(IInventory inventory, EntityPlayer player) {
        this.inventory = inventory;
        this.width = this.height = (int)Math.sqrt(inventory.getSizeInventory());
        this.stacks = new IItemStack[this.width * this.height];
        this.original = new ItemStack[this.stacks.length];
        this.stackCount = 0;
        this.update();
        this.playerOrig = player;
        this.player = player == null ? null : new MCPlayer(player);
    }

    private void update() {
        if (this.inventory.getSizeInventory() != this.original.length) {
            this.width = this.height = (int)Math.sqrt(this.inventory.getSizeInventory());
            this.stacks = new IItemStack[this.inventory.getSizeInventory()];
            this.original = new ItemStack[this.stacks.length];
            this.stackCount = 0;
        }
        for (int i = 0; i < this.inventory.getSizeInventory(); ++i) {
            if (!this.changed(i)) continue;
            this.original[i] = this.inventory.getStackInSlot(i);
            if (this.inventory.getStackInSlot(i) != null) {
                if (this.stacks[i] == null) {
                    ++this.stackCount;
                }
                this.stacks[i] = MineTweakerMC.getIItemStack(this.original[i]);
                continue;
            }
            if (this.stacks[i] != null) {
                --this.stackCount;
            }
            this.stacks[i] = null;
        }
    }

    @Override
    public IPlayer getPlayer() {
        return this.player;
    }

    @Override
    public int getSize() {
        return this.width * this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStackCount() {
        return this.stackCount;
    }

    @Override
    public IItemStack getStack(int i) {
        return this.stacks[i];
    }

    @Override
    public IItemStack getStack(int x, int y) {
        return this.stacks[y * this.width + x];
    }

    @Override
    public void setStack(int x, int y, IItemStack stack) {
        int ix = y * this.width + x;
        if (stack != this.stacks[ix]) {
            if (stack == null) {
                --this.stackCount;
                this.inventory.setInventorySlotContents(ix, null);
            } else {
                this.inventory.setInventorySlotContents(ix, MineTweakerMC.getItemStack(stack));
                if (this.stacks[ix] == null) {
                    ++this.stackCount;
                }
            }
            this.stacks[ix] = stack;
        }
    }

    @Override
    public void setStack(int i, IItemStack stack) {
        if (stack != this.stacks[i]) {
            if (stack == null) {
                --this.stackCount;
                this.inventory.setInventorySlotContents(i, null);
            } else {
                this.inventory.setInventorySlotContents(i, MineTweakerMC.getItemStack(stack));
                if (this.stacks[i] == null) {
                    ++this.stackCount;
                }
            }
            this.stacks[i] = stack;
        }
    }

    private boolean changed(int i) {
        if (this.original[i] != this.inventory.getStackInSlot(i)) {
            return true;
        }
        return this.original[i] != null && this.stacks[i].getAmount() != this.original[i].stackSize;
    }
}

