/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.recipes;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.player.IPlayer;
import minetweaker.api.recipes.ICraftingInventory;
import minetweaker.api.recipes.ICraftingRecipe;
import minetweaker.api.recipes.IRecipeFunction;
import minetweaker.api.recipes.IRecipeManager;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.api.recipes.ShapelessRecipe;
import minetweaker.mc1710.recipes.RecipeConverter;
import minetweaker.mc1710.util.MineTweakerHacks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class MCRecipeManager
implements IRecipeManager {
    private final List<IRecipe> recipes = CraftingManager.getInstance().getRecipeList();
    private final List<ICraftingRecipe> transformerRecipes = new ArrayList<ICraftingRecipe>();

    public boolean hasTransformerRecipes() {
        return this.transformerRecipes.size() > 0;
    }

    public void applyTransformations(ICraftingInventory inventory, IPlayer byPlayer) {
        for (ICraftingRecipe recipe : this.transformerRecipes) {
            if (!recipe.matches(inventory)) continue;
            recipe.applyTransformers(inventory, byPlayer);
            return;
        }
    }

    @Override
    public List<ICraftingRecipe> getRecipesFor(IIngredient ingredient) {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : this.recipes) {
            if (!ingredient.matches(MineTweakerMC.getIItemStack(recipe.getRecipeOutput()))) continue;
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public List<ICraftingRecipe> getAll() {
        ArrayList<ICraftingRecipe> results = new ArrayList<ICraftingRecipe>();
        for (IRecipe recipe : this.recipes) {
            ICraftingRecipe converted = RecipeConverter.toCraftingRecipe(recipe);
            results.add(converted);
        }
        return results;
    }

    @Override
    public int remove(IIngredient output) {
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe recipe = this.recipes.get(i);
            if (recipe.getRecipeOutput() == null || !output.matches(MineTweakerMC.getIItemStack(recipe.getRecipeOutput()))) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply(new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @Override
    public void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function) {
        this.addShaped(output, ingredients, function, false);
    }

    @Override
    public void addShapedMirrored(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function) {
        this.addShaped(output, ingredients, function, true);
    }

    @Override
    public void addShapeless(IItemStack output, IIngredient[] ingredients, IRecipeFunction function) {
        ShapelessRecipe recipe = new ShapelessRecipe(output, ingredients, function);
        IRecipe irecipe = RecipeConverter.convert(recipe);
        MineTweakerAPI.apply(new ActionAddRecipe(irecipe, recipe));
    }

    @Override
    public int removeShaped(IIngredient output, IIngredient[][] ingredients) {
        int ingredientsWidth = 0;
        int ingredientsHeight = 0;
        if (ingredients != null) {
            ingredientsHeight = ingredients.length;
            for (int i = 0; i < ingredients.length; ++i) {
                ingredientsWidth = Math.max(ingredientsWidth, ingredients[i].length);
            }
        }
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        block1: for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe recipe = this.recipes.get(i);
            if (recipe.getRecipeOutput() == null || !output.matches(MineTweakerMC.getIItemStack(recipe.getRecipeOutput()))) continue;
            if (ingredients != null) {
                ShapedRecipes srecipe;
                if (recipe instanceof ShapedRecipes) {
                    srecipe = (ShapedRecipes)recipe;
                    if (ingredientsWidth != srecipe.recipeWidth || ingredientsHeight != srecipe.recipeHeight) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            ItemStack recipeIngredient = srecipe.recipeItems[j * srecipe.recipeWidth + k];
                            IIngredient ingredient = k > row.length ? null : row[k];
                            if (!MCRecipeManager.matches(recipeIngredient, ingredient)) continue block1;
                        }
                    }
                } else if (recipe instanceof ShapedOreRecipe) {
                    srecipe = (ShapedOreRecipe)recipe;
                    int recipeWidth = MineTweakerHacks.getShapedOreRecipeWidth((ShapedOreRecipe)srecipe);
                    int recipeHeight = srecipe.getRecipeSize() / recipeWidth;
                    if (ingredientsWidth != recipeWidth || ingredientsHeight != recipeHeight) continue;
                    for (int j = 0; j < ingredientsHeight; ++j) {
                        IIngredient[] row = ingredients[j];
                        for (int k = 0; k < ingredientsWidth; ++k) {
                            IIngredient ingredient = k > row.length ? null : row[k];
                            Object input = srecipe.getInput()[j * recipeWidth + k];
                            if (!MCRecipeManager.matches(input, ingredient)) continue block1;
                        }
                    }
                }
            } else if (!(recipe instanceof ShapedRecipes) && !(recipe instanceof ShapedOreRecipe)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply(new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @Override
    public int removeShapeless(IIngredient output, IIngredient[] ingredients, boolean wildcard) {
        ArrayList<IRecipe> toRemove = new ArrayList<IRecipe>();
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        block0: for (int i = 0; i < this.recipes.size(); ++i) {
            IRecipe recipe = this.recipes.get(i);
            if (recipe.getRecipeOutput() == null || !output.matches(MineTweakerMC.getIItemStack(recipe.getRecipeOutput()))) continue;
            if (ingredients != null) {
                ShapelessRecipes srecipe;
                if (recipe instanceof ShapelessRecipes) {
                    srecipe = (ShapelessRecipes)recipe;
                    if (ingredients.length > srecipe.getRecipeSize() || !wildcard && ingredients.length < srecipe.getRecipeSize()) continue;
                    block1: for (int j = 0; j < ingredients.length; ++j) {
                        for (int k = 0; k < srecipe.getRecipeSize(); ++k) {
                            if (MCRecipeManager.matches(srecipe.recipeItems.get(k), ingredients[j])) continue block1;
                        }
                        continue block0;
                    }
                } else if (recipe instanceof ShapelessOreRecipe) {
                    srecipe = (ShapelessOreRecipe)recipe;
                    ArrayList inputs = srecipe.getInput();
                    if (inputs.size() < ingredients.length || !wildcard && inputs.size() > ingredients.length) continue;
                    block3: for (int j = 0; j < ingredients.length; ++j) {
                        for (int k = 0; k < srecipe.getRecipeSize(); ++k) {
                            if (MCRecipeManager.matches(inputs.get(k), ingredients[j])) continue block3;
                        }
                        continue block0;
                    }
                }
            } else if (!(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
            toRemove.add(recipe);
            removeIndex.add(i);
        }
        MineTweakerAPI.apply(new ActionRemoveRecipes(toRemove, removeIndex));
        return toRemove.size();
    }

    @Override
    public IItemStack craft(IItemStack[][] contents) {
        ContainerVirtual container = new ContainerVirtual();
        int width = 0;
        int height = contents.length;
        for (IItemStack[] row : contents) {
            width = Math.max(width, row.length);
        }
        ItemStack[] iContents = new ItemStack[width * height];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < contents[i].length; ++j) {
                if (contents[i][j] == null) continue;
                iContents[i * width + j] = MineTweakerMC.getItemStack(contents[i][j]);
            }
        }
        InventoryCrafting inventory = new InventoryCrafting((Container)container, width, height);
        for (int i = 0; i < iContents.length; ++i) {
            inventory.setInventorySlotContents(i, iContents[i]);
        }
        ItemStack result = CraftingManager.getInstance().findMatchingRecipe(inventory, null);
        if (result == null) {
            return null;
        }
        return MineTweakerMC.getIItemStack(result);
    }

    private void addShaped(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, boolean mirrored) {
        ShapedRecipe recipe = new ShapedRecipe(output, ingredients, function, mirrored);
        IRecipe irecipe = RecipeConverter.convert(recipe);
        MineTweakerAPI.apply(new ActionAddRecipe(irecipe, recipe));
    }

    private static boolean matches(Object input, IIngredient ingredient) {
        if (input == null != (ingredient == null)) {
            return false;
        }
        return ingredient == null || !(input instanceof ItemStack ? !ingredient.matches(MineTweakerMC.getIItemStack((ItemStack)input)) : input instanceof String && !ingredient.contains(MineTweakerMC.getOreDict((String)input)));
    }

    private class ActionAddRecipe
    implements IUndoableAction {
        private final IRecipe recipe;
        private final ICraftingRecipe craftingRecipe;

        public ActionAddRecipe(IRecipe recipe, ICraftingRecipe craftingRecipe) {
            this.recipe = recipe;
            this.craftingRecipe = craftingRecipe;
        }

        @Override
        public void apply() {
            MCRecipeManager.this.recipes.add(this.recipe);
            if (this.craftingRecipe.hasTransformers()) {
                MCRecipeManager.this.transformerRecipes.add(this.craftingRecipe);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MCRecipeManager.this.recipes.remove(this.recipe);
            if (this.craftingRecipe.hasTransformers()) {
                MCRecipeManager.this.transformerRecipes.remove(this.craftingRecipe);
            }
        }

        @Override
        public String describe() {
            return "Adding recipe for " + this.recipe.getRecipeOutput().getDisplayName();
        }

        @Override
        public String describeUndo() {
            return "Removing recipe for " + this.recipe.getRecipeOutput().getDisplayName();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ActionRemoveRecipes
    implements IUndoableAction {
        private final List<Integer> removingIndices;
        private final List<IRecipe> removingRecipes;

        public ActionRemoveRecipes(List<IRecipe> recipes, List<Integer> indices) {
            this.removingIndices = indices;
            this.removingRecipes = recipes;
        }

        @Override
        public void apply() {
            for (int i = this.removingIndices.size() - 1; i >= 0; --i) {
                MCRecipeManager.this.recipes.remove(this.removingIndices.get(i));
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (int i = 0; i < this.removingIndices.size(); ++i) {
                int index = Math.min(MCRecipeManager.this.recipes.size(), this.removingIndices.get(i));
                MCRecipeManager.this.recipes.add(index, this.removingRecipes.get(i));
            }
        }

        @Override
        public String describe() {
            return "Removing " + this.removingIndices.size() + " recipes";
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.removingIndices.size() + " recipes";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private class ContainerVirtual
    extends Container {
        private ContainerVirtual() {
        }

        public boolean canInteractWith(EntityPlayer var1) {
            return false;
        }
    }
}

