/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.util;

import com.google.common.collect.BiMap;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1710.util.MineTweakerObfuscation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class MineTweakerHacks {
    private static final Field NBTTAGLIST_TAGLIST = MineTweakerHacks.getField(NBTTagList.class, MineTweakerObfuscation.NBTTAGLIST_TAGLIST);
    private static final Field OREDICTIONARY_IDTOSTACK = MineTweakerHacks.getField(OreDictionary.class, MineTweakerObfuscation.OREDICTIONARY_IDTOSTACK);
    private static final Field OREDICTIONARY_IDTOSTACKUN = MineTweakerHacks.getField(OreDictionary.class, MineTweakerObfuscation.OREDICTIONARY_IDTOSTACKUN);
    private static final Field MINECRAFTSERVER_ANVILFILE = MineTweakerHacks.getField(MinecraftServer.class, MineTweakerObfuscation.MINECRAFTSERVER_ANVILFILE);
    private static final Field SHAPEDORERECIPE_WIDTH = MineTweakerHacks.getField(ShapedOreRecipe.class, "width");
    private static final Field INVENTORYCRAFTING_EVENTHANDLER = MineTweakerHacks.getField(InventoryCrafting.class, MineTweakerObfuscation.INVENTORYCRAFTING_EVENTHANDLER);
    private static final Field SLOTCRAFTING_PLAYER = MineTweakerHacks.getField(SlotCrafting.class, MineTweakerObfuscation.SLOTCRAFTING_PLAYER);
    private static final Field ENTITYREGISTRY_CLASSREGISTRATIONS = MineTweakerHacks.getField(EntityRegistry.class, "entityClassRegistrations");
    private static final Field SEEDENTRY_SEED;
    private static final Constructor<? extends WeightedRandom.Item> SEEDENTRY_CONSTRUCTOR;

    private MineTweakerHacks() {
    }

    public static BiMap<Class<? extends Entity>, EntityRegistry.EntityRegistration> getEntityClassRegistrations() {
        try {
            return (BiMap)ENTITYREGISTRY_CLASSREGISTRATIONS.get(EntityRegistry.instance());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static List<NBTBase> getTagList(NBTTagList list) {
        if (NBTTAGLIST_TAGLIST == null) {
            return null;
        }
        try {
            return (List)NBTTAGLIST_TAGLIST.get(list);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static List getSeeds() {
        return (List)MineTweakerHacks.getPrivateStaticObject(ForgeHooks.class, "seedList");
    }

    public static Map<String, ChestGenHooks> getChestLoot() {
        return (Map)MineTweakerHacks.getPrivateStaticObject(ChestGenHooks.class, "chestInfo");
    }

    public static Map getTranslations() {
        return (Map)MineTweakerHacks.getPrivateObject(MineTweakerHacks.getPrivateStaticObject(StatCollector.class, "localizedName", "field_74839_a"), "languageList", "field_74816_c");
    }

    public static List<ArrayList<ItemStack>> getOreIdStacks() {
        try {
            return (List)OREDICTIONARY_IDTOSTACK.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static List<ArrayList<ItemStack>> getOreIdStacksUn() {
        try {
            return (List)OREDICTIONARY_IDTOSTACKUN.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static File getAnvilFile(MinecraftServer server) {
        try {
            return (File)MINECRAFTSERVER_ANVILFILE.get(server);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not load anvil file!");
            return null;
        }
    }

    public static File getWorldDirectory(MinecraftServer server) {
        if (server.isDedicatedServer()) {
            return server.getFile("world");
        }
        File worldsDir = MineTweakerHacks.getAnvilFile(server);
        if (worldsDir == null) {
            return null;
        }
        return new File(worldsDir, server.getFolderName());
    }

    public static int getShapedOreRecipeWidth(ShapedOreRecipe recipe) {
        try {
            return SHAPEDORERECIPE_WIDTH.getInt(recipe);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not load anvil file!");
            return 3;
        }
    }

    public static Container getCraftingContainer(InventoryCrafting inventory) {
        try {
            return (Container)INVENTORYCRAFTING_EVENTHANDLER.get(inventory);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get inventory eventhandler");
            return null;
        }
    }

    public static EntityPlayer getCraftingSlotPlayer(SlotCrafting slot) {
        try {
            return (EntityPlayer)SLOTCRAFTING_PLAYER.get(slot);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get inventory eventhandler");
            return null;
        }
    }

    public static StringTranslate getStringTranslateInstance() {
        try {
            Field field = MineTweakerHacks.getField(StringTranslate.class, MineTweakerObfuscation.STRINGTRANSLATE_INSTANCE);
            return (StringTranslate)field.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get string translator");
            return null;
        }
    }

    public static ItemStack getSeedEntrySeed(Object entry) {
        try {
            return (ItemStack)SEEDENTRY_SEED.get(entry);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get SeedEntry seed");
            return null;
        }
    }

    public static WeightedRandom.Item constructSeedEntry(WeightedItemStack stack) {
        try {
            return SEEDENTRY_CONSTRUCTOR.newInstance(MineTweakerMC.getItemStack(stack.getStack()), (int)stack.getChance());
        }
        catch (InstantiationException ex) {
            MineTweakerAPI.logError("could not construct SeedEntry");
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not construct SeedEntry");
        }
        catch (IllegalArgumentException ex) {
            MineTweakerAPI.logError("could not construct SeedEntry");
        }
        catch (InvocationTargetException ex) {
            MineTweakerAPI.logError("could not construct SeedEntry");
        }
        return null;
    }

    public static <T> T getPrivateStaticObject(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(null);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T getPrivateObject(Object object, String ... names) {
        Class<?> cls = object.getClass();
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(object);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private static Field getField(Class cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Class<?> forgeSeedEntry = null;
        try {
            forgeSeedEntry = Class.forName("net.minecraftforge.common.ForgeHooks$SeedEntry");
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        SEEDENTRY_SEED = MineTweakerHacks.getField(forgeSeedEntry, "seed");
        Constructor<?> seedEntryConstructor = null;
        try {
            seedEntryConstructor = forgeSeedEntry.getConstructor(ItemStack.class, Integer.TYPE);
            seedEntryConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(MineTweakerHacks.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(MineTweakerHacks.class.getName()).log(Level.SEVERE, null, ex);
        }
        SEEDENTRY_CONSTRUCTOR = seedEntryConstructor;
    }
}

